/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Consumer;
import net.dreamlu.iot.mqtt.codec.MqttMessageBuilders;
import net.dreamlu.iot.mqtt.codec.MqttProperties;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.core.client.MqttClientSubscription;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.Ordered;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;

public class MqttClientTemplate
implements InitializingBean,
DisposableBean,
Ordered {
    public static final String DEFAULT_CLIENT_TEMPLATE_BEAN = "mqttClientTemplate";
    private final MqttClientCreator mqttClientCreator;
    private final ObjectProvider<IMqttClientConnectListener> clientConnectListenerObjectProvider;
    private MqttClient client;

    public MqttClient subQos0(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_MOST_ONCE, listener, null);
    }

    public MqttClient subQos0(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_MOST_ONCE, listener, properties);
    }

    public MqttClient subQos1(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_LEAST_ONCE, listener, null);
    }

    public MqttClient subQos1(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_LEAST_ONCE, listener, properties);
    }

    public MqttClient subQos2(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.EXACTLY_ONCE, listener, null);
    }

    public MqttClient subQos2(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.EXACTLY_ONCE, listener, properties);
    }

    public MqttClient subscribe(MqttQoS mqttQoS, String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, mqttQoS, listener, null);
    }

    public MqttClient subscribe(String topicFilter, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, mqttQoS, listener, null);
    }

    public MqttClient subscribe(String topicFilter, MqttQoS mqttQoS, IMqttClientMessageListener listener, MqttProperties properties) {
        return this.client.subscribe(topicFilter, mqttQoS, listener, properties);
    }

    public MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilters, mqttQoS, listener, null);
    }

    public MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener, MqttProperties properties) {
        return this.client.subscribe(topicFilters, mqttQoS, listener, properties);
    }

    public MqttClient subscribe(List<MqttClientSubscription> subscriptionList) {
        return this.client.subscribe(subscriptionList, null);
    }

    public MqttClient subscribe(List<MqttClientSubscription> subscriptionList, MqttProperties properties) {
        return this.client.subscribe(subscriptionList, properties);
    }

    public MqttClient unSubscribe(String ... topicFilters) {
        return this.client.unSubscribe(topicFilters, null);
    }

    public MqttClient unSubscribe(List<String> topicFilters) {
        return this.client.unSubscribe(topicFilters, null);
    }

    public MqttClient unSubscribe(String topicFilter, MqttProperties properties) {
        return this.client.unSubscribe(topicFilter, properties);
    }

    public MqttClient unSubscribe(String[] topicFilters, MqttProperties properties) {
        return this.client.unSubscribe(topicFilters, properties);
    }

    public MqttClient unSubscribe(List<String> topicFilters, MqttProperties properties) {
        return this.client.unSubscribe(topicFilters, properties);
    }

    public boolean publish(String topic, ByteBuffer payload) {
        return this.client.publish(topic, payload);
    }

    public boolean publish(String topic, byte[] payload) {
        return this.client.publish(topic, payload);
    }

    public boolean publish(String topic, ByteBuffer payload, MqttQoS qos) {
        return this.client.publish(topic, payload, qos);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos) {
        return this.client.publish(topic, payload, qos);
    }

    public boolean publish(String topic, ByteBuffer payload, boolean retain) {
        return this.client.publish(topic, payload, retain);
    }

    public boolean publish(String topic, byte[] payload, boolean retain) {
        return this.client.publish(topic, payload, retain);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos, boolean retain) {
        return this.client.publish(topic, payload, qos, retain);
    }

    public boolean publish(String topic, ByteBuffer payload, MqttQoS qos, boolean retain) {
        return this.client.publish(topic, payload, qos, retain);
    }

    public boolean publish(String topic, ByteBuffer payload, MqttQoS qos, boolean retain, MqttProperties properties) {
        return this.client.publish(topic, payload, qos, retain, properties);
    }

    public boolean publish(String topic, ByteBuffer payload, MqttQoS qos, Consumer<MqttMessageBuilders.PublishBuilder> builder) {
        return this.client.publish(topic, payload, qos, builder);
    }

    public void reconnect() {
        this.client.reconnect();
    }

    public boolean disconnect() {
        return this.client.disconnect();
    }

    public TioClient getTioClient() {
        return this.client.getTioClient();
    }

    public MqttClientCreator getClientCreator() {
        return this.client.getClientCreator();
    }

    public TioClientConfig getClientTioConfig() {
        return this.client.getClientTioConfig();
    }

    public ClientChannelContext getContext() {
        return this.client.getContext();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public boolean isDisconnected() {
        return this.client.isDisconnected();
    }

    public void afterPropertiesSet() {
        this.clientConnectListenerObjectProvider.ifAvailable(arg_0 -> ((MqttClientCreator)this.mqttClientCreator).connectListener(arg_0));
        this.client = this.mqttClientCreator.connect();
    }

    public void destroy() {
        this.client.stop();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public MqttClientTemplate(MqttClientCreator mqttClientCreator, ObjectProvider<IMqttClientConnectListener> clientConnectListenerObjectProvider) {
        this.mqttClientCreator = mqttClientCreator;
        this.clientConnectListenerObjectProvider = clientConnectListenerObjectProvider;
    }
}

