/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import net.dreamlu.iot.mqtt.codec.MqttPublishMessage;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;
import net.dreamlu.iot.mqtt.spring.client.MqttClientSubscribe;
import net.dreamlu.iot.mqtt.spring.client.MqttClientSubscribeMessageListener;
import net.dreamlu.iot.mqtt.spring.client.MqttClientTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MqttClientSubscribeDetector
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(MqttClientSubscribeDetector.class);
    private final ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        Class userClass = ClassUtils.getUserClass((Object)bean);
        if (bean instanceof IMqttClientMessageListener) {
            MqttClientSubscribe subscribe = (MqttClientSubscribe)AnnotationUtils.findAnnotation((Class)userClass, MqttClientSubscribe.class);
            if (subscribe != null) {
                MqttClientTemplate clientTemplate = MqttClientSubscribeDetector.getMqttClientTemplate(this.applicationContext, subscribe.clientTemplateBean());
                String[] topicFilters = MqttClientSubscribeDetector.getTopicFilters(this.applicationContext, subscribe.value());
                clientTemplate.subscribe(topicFilters, subscribe.qos(), (IMqttClientMessageListener)bean);
            }
        } else {
            ReflectionUtils.doWithMethods((Class)userClass, method -> {
                MqttClientSubscribe subscribe = (MqttClientSubscribe)AnnotationUtils.findAnnotation((Method)method, MqttClientSubscribe.class);
                if (subscribe != null) {
                    int modifiers = method.getModifiers();
                    if (Modifier.isStatic(modifiers)) {
                        throw new IllegalArgumentException("@MqttClientSubscribe on method " + method + " must not static.");
                    }
                    if (!Modifier.isPublic(modifiers)) {
                        throw new IllegalArgumentException("@MqttClientSubscribe on method " + method + " must public.");
                    }
                    int paramCount = method.getParameterCount();
                    if (paramCount < 2 || paramCount > 4) {
                        throw new IllegalArgumentException("@MqttClientSubscribe on method " + method + " parameter count must 2 ~ 4.");
                    }
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    MqttClientSubscribeDetector.checkParameterTypes(method, parameterTypes);
                    MqttClientTemplate clientTemplate = MqttClientSubscribeDetector.getMqttClientTemplate(this.applicationContext, subscribe.clientTemplateBean());
                    String[] topicTemplates = subscribe.value();
                    String[] topicFilters = MqttClientSubscribeDetector.getTopicFilters(this.applicationContext, topicTemplates);
                    MqttClientSubscribeMessageListener messageListener = new MqttClientSubscribeMessageListener(bean, method, topicTemplates, topicFilters);
                    clientTemplate.subscribe(topicFilters, subscribe.qos(), (IMqttClientMessageListener)messageListener);
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return bean;
    }

    private static MqttClientTemplate getMqttClientTemplate(ApplicationContext applicationContext, String beanName) {
        return (MqttClientTemplate)applicationContext.getBean(beanName, MqttClientTemplate.class);
    }

    private static String[] getTopicFilters(ApplicationContext applicationContext, String[] values) {
        return (String[])Arrays.stream(values).map(arg_0 -> ((Environment)applicationContext.getEnvironment()).resolvePlaceholders(arg_0)).map(TopicUtil::getTopicFilter).toArray(String[]::new);
    }

    private static void checkParameterTypes(Method method, Class<?>[] parameterTypes) {
        for (Class<?> parameterType : parameterTypes) {
            if (String.class == parameterType || Map.class == parameterType || MqttPublishMessage.class == parameterType || ByteBuffer.class == parameterType) continue;
            throw new IllegalArgumentException("@MqttClientSubscribe on method " + method + " parameter type must String topic, Map<String, String> topicVars, MqttPublishMessage message or ByteBuffer payload.");
        }
    }

    public MqttClientSubscribeDetector(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

