/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import net.dreamlu.iot.mqtt.codec.MqttPublishMessage;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.common.TopicFilterType;
import org.springframework.util.ReflectionUtils;
import org.tio.core.ChannelContext;

class MqttClientSubscribeMessageListener
implements IMqttClientMessageListener {
    private final Object bean;
    private final Method method;
    private final String[] topicTemplates;
    private final String[] topicFilters;

    public void onMessage(ChannelContext context, String topic, MqttPublishMessage message, byte[] payload) {
        Object[] methodParameters = MqttClientSubscribeMessageListener.getMethodParameters(this.method, this.topicTemplates, this.topicFilters, topic, message, payload);
        ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])methodParameters);
    }

    private static Object[] getMethodParameters(Method method, String[] topicTemplates, String[] topicFilters, String topic, MqttPublishMessage message, byte[] payload) {
        int paramCount = method.getParameterCount();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] parameters = new Object[paramCount];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (parameterType == String.class) {
                parameters[i] = topic;
                continue;
            }
            if (parameterType == Map.class) {
                parameters[i] = MqttClientSubscribeMessageListener.getTopicVars(topicTemplates, topicFilters, topic);
                continue;
            }
            if (parameterType == MqttPublishMessage.class) {
                parameters[i] = message;
                continue;
            }
            if (parameterType == byte[].class) {
                parameters[i] = payload;
                continue;
            }
            if (parameterType != ByteBuffer.class) continue;
            parameters[i] = ByteBuffer.wrap(payload);
        }
        return parameters;
    }

    private static Map<String, String> getTopicVars(String[] topicTemplates, String[] topicFilters, String topic) {
        for (int j = 0; j < topicFilters.length; ++j) {
            String topicFilter = topicFilters[j];
            TopicFilterType topicFilterType = TopicFilterType.getType((String)topicFilter);
            if (!topicFilterType.match(topicFilter, topic)) continue;
            String topicTemplate = topicTemplates[j];
            return topicFilterType.extractTopicVars(topicTemplate, topic);
        }
        return Collections.emptyMap();
    }

    public MqttClientSubscribeMessageListener(Object bean, Method method, String[] topicTemplates, String[] topicFilters) {
        this.bean = bean;
        this.method = method;
        this.topicTemplates = topicTemplates;
        this.topicFilters = topicFilters;
    }
}

