/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.dreamlu.iot.mqtt.codec.MqttMessageBuilders;
import net.dreamlu.iot.mqtt.codec.MqttProperties;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientGlobalMessageListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.core.client.MqttClientSubscription;
import net.dreamlu.iot.mqtt.spring.client.MqttClientCustomizer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.Ordered;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;

public class MqttClientTemplate
implements SmartInitializingSingleton,
DisposableBean,
Ordered {
    public static final String DEFAULT_CLIENT_TEMPLATE_BEAN = "mqttClientTemplate";
    private final MqttClientCreator clientCreator;
    private final ObjectProvider<IMqttClientConnectListener> clientConnectListenerObjectProvider;
    private final ObjectProvider<IMqttClientGlobalMessageListener> globalMessageListenerObjectProvider;
    private final ObjectProvider<MqttClientCustomizer> customizersObjectProvider;
    private final List<MqttClientSubscription> tempSubscriptionList;
    private MqttClient client;

    public MqttClientTemplate(MqttClientCreator clientCreator, ObjectProvider<IMqttClientConnectListener> clientConnectListenerObjectProvider) {
        this(clientCreator, clientConnectListenerObjectProvider, null, null);
    }

    public MqttClientTemplate(MqttClientCreator clientCreator, ObjectProvider<IMqttClientConnectListener> clientConnectListenerObjectProvider, ObjectProvider<IMqttClientGlobalMessageListener> globalMessageListenerObjectProvider, ObjectProvider<MqttClientCustomizer> customizersObjectProvider) {
        this.clientCreator = clientCreator;
        this.clientConnectListenerObjectProvider = clientConnectListenerObjectProvider;
        this.globalMessageListenerObjectProvider = globalMessageListenerObjectProvider;
        this.customizersObjectProvider = customizersObjectProvider;
        this.tempSubscriptionList = new ArrayList<MqttClientSubscription>();
    }

    public MqttClient subQos0(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_MOST_ONCE, listener, null);
    }

    public MqttClient subQos0(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_MOST_ONCE, listener, properties);
    }

    public MqttClient subQos1(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_LEAST_ONCE, listener, null);
    }

    public MqttClient subQos1(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.AT_LEAST_ONCE, listener, properties);
    }

    public MqttClient subQos2(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.EXACTLY_ONCE, listener, null);
    }

    public MqttClient subQos2(String topicFilter, MqttProperties properties, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.EXACTLY_ONCE, listener, properties);
    }

    public MqttClient subscribe(MqttQoS mqttQoS, String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, mqttQoS, listener, null);
    }

    public MqttClient subscribe(String topicFilter, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, mqttQoS, listener, null);
    }

    public MqttClient subscribe(String topicFilter, MqttQoS mqttQoS, IMqttClientMessageListener listener, MqttProperties properties) {
        return this.client.subscribe(topicFilter, mqttQoS, listener, properties);
    }

    public MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilters, mqttQoS, listener, null);
    }

    public MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener, MqttProperties properties) {
        return this.client.subscribe(topicFilters, mqttQoS, listener, properties);
    }

    public MqttClient subscribe(List<MqttClientSubscription> subscriptionList) {
        return this.client.subscribe(subscriptionList, null);
    }

    public MqttClient subscribe(List<MqttClientSubscription> subscriptionList, MqttProperties properties) {
        return this.client.subscribe(subscriptionList, properties);
    }

    public MqttClient unSubscribe(String ... topicFilters) {
        return this.client.unSubscribe(topicFilters, null);
    }

    public MqttClient unSubscribe(List<String> topicFilters) {
        return this.client.unSubscribe(topicFilters, null);
    }

    public MqttClient unSubscribe(String topicFilter, MqttProperties properties) {
        return this.client.unSubscribe(topicFilter, properties);
    }

    public MqttClient unSubscribe(String[] topicFilters, MqttProperties properties) {
        return this.client.unSubscribe(topicFilters, properties);
    }

    public MqttClient unSubscribe(List<String> topicFilters, MqttProperties properties) {
        return this.client.unSubscribe(topicFilters, properties);
    }

    public boolean publish(String topic, byte[] payload) {
        return this.client.publish(topic, payload);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos) {
        return this.client.publish(topic, payload, qos);
    }

    public boolean publish(String topic, byte[] payload, boolean retain) {
        return this.client.publish(topic, payload, retain);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos, boolean retain) {
        return this.client.publish(topic, payload, qos, retain);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos, boolean retain, MqttProperties properties) {
        return this.client.publish(topic, payload, qos, retain, properties);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos, Consumer<MqttMessageBuilders.PublishBuilder> builder) {
        return this.client.publish(topic, payload, qos, builder);
    }

    public void reconnect() {
        this.client.reconnect();
    }

    public boolean reconnect(String ip, int port) {
        return this.client.reconnect(ip, port);
    }

    public boolean disconnect() {
        return this.client.disconnect();
    }

    public TioClient getTioClient() {
        return this.client.getTioClient();
    }

    public MqttClientCreator getClientCreator() {
        return this.clientCreator;
    }

    public TioClientConfig getClientTioConfig() {
        return this.client.getClientTioConfig();
    }

    public ClientChannelContext getContext() {
        return this.client.getContext();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public boolean isDisconnected() {
        return this.client.isDisconnected();
    }

    void addSubscriptionList(String[] topicFilters, MqttQoS qos, IMqttClientMessageListener messageListener) {
        for (String topicFilter : topicFilters) {
            this.tempSubscriptionList.add(new MqttClientSubscription(qos, topicFilter, messageListener));
        }
    }

    public void afterSingletonsInstantiated() {
        Integer timeout;
        this.clientConnectListenerObjectProvider.ifAvailable(arg_0 -> ((MqttClientCreator)this.clientCreator).connectListener(arg_0));
        if (this.globalMessageListenerObjectProvider != null) {
            this.globalMessageListenerObjectProvider.ifAvailable(arg_0 -> ((MqttClientCreator)this.clientCreator).globalMessageListener(arg_0));
        }
        if (this.customizersObjectProvider != null) {
            this.customizersObjectProvider.ifAvailable(customizer -> customizer.customize(this.clientCreator));
        }
        if ((timeout = this.clientCreator.getTimeout()) == null) {
            this.clientCreator.timeout(3);
        }
        this.client = this.clientCreator.connectSync();
        this.client.subscribe(this.tempSubscriptionList);
        this.tempSubscriptionList.clear();
    }

    public void destroy() {
        this.client.stop();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

