/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client.config;

import java.nio.charset.StandardCharsets;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientSession;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.spring.client.MqttClientCustomizer;
import net.dreamlu.iot.mqtt.spring.client.MqttClientSubscribeDetector;
import net.dreamlu.iot.mqtt.spring.client.MqttClientTemplate;
import net.dreamlu.iot.mqtt.spring.client.config.MqttClientProperties;
import net.dreamlu.iot.mqtt.spring.client.event.SpringEventMqttClientConnectListener;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="mqtt.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttClientProperties.class})
public class MqttClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public IMqttClientConnectListener springEventMqttClientConnectListener(ApplicationEventPublisher eventPublisher) {
        return new SpringEventMqttClientConnectListener(eventPublisher);
    }

    @Bean
    public MqttClientCreator mqttClientCreator(MqttClientProperties properties, ObjectProvider<IMqttClientSession> clientSessionObjectProvider, ObjectProvider<MqttClientCustomizer> customizers) {
        MqttClientProperties.WillMessage willMessage;
        MqttClientProperties.Ssl ssl;
        MqttClientCreator clientCreator = MqttClient.create().name(properties.getName()).ip(properties.getIp()).port(properties.getPort()).username(properties.getUserName()).password(properties.getPassword()).clientId(properties.getClientId()).readBufferSize((int)properties.getReadBufferSize().toBytes()).maxBytesInMessage((int)properties.getMaxBytesInMessage().toBytes()).maxClientIdLength(properties.getMaxClientIdLength()).keepAliveSecs(properties.getKeepAliveSecs()).reconnect(properties.isReconnect()).reInterval(properties.getReInterval()).retryCount(properties.getRetryCount()).reSubscribeBatchSize(properties.getReSubscribeBatchSize()).version(properties.getVersion()).cleanSession(properties.isCleanSession()).bufferAllocator(properties.getBufferAllocator()).statEnable(properties.isStatEnable()).debug(properties.isDebug());
        Integer timeout = properties.getTimeout();
        if (timeout != null && timeout > 0) {
            clientCreator.timeout(timeout.intValue());
        }
        if ((ssl = properties.getSsl()).isEnabled()) {
            clientCreator.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass());
        }
        if ((willMessage = properties.getWillMessage()) != null && StringUtils.hasText((String)willMessage.getTopic())) {
            clientCreator.willMessage(builder -> {
                builder.topic(willMessage.getTopic()).qos(willMessage.getQos()).retain(willMessage.isRetain());
                if (StringUtils.hasText((String)willMessage.getMessage())) {
                    builder.message(willMessage.getMessage().getBytes(StandardCharsets.UTF_8));
                }
            });
        }
        clientSessionObjectProvider.ifAvailable(arg_0 -> ((MqttClientCreator)clientCreator).clientSession(arg_0));
        customizers.ifAvailable(customizer -> customizer.customize(clientCreator));
        return clientCreator;
    }

    @Bean(value={"mqttClientTemplate"})
    public MqttClientTemplate mqttClientTemplate(MqttClientCreator mqttClientCreator, ObjectProvider<IMqttClientConnectListener> clientConnectListenerObjectProvider) {
        return new MqttClientTemplate(mqttClientCreator, clientConnectListenerObjectProvider);
    }

    @Bean
    public MqttClientSubscribeDetector mqttClientSubscribeDetector(ApplicationContext applicationContext) {
        return new MqttClientSubscribeDetector(applicationContext);
    }
}

