/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server.event;

import java.util.concurrent.TimeUnit;
import net.dreamlu.iot.mqtt.core.server.event.IMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.spring.server.event.MqttClientOfflineEvent;
import net.dreamlu.iot.mqtt.spring.server.event.MqttClientOnlineEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.tio.core.ChannelContext;
import org.tio.core.Node;

public class SpringEventMqttConnectStatusListener
implements IMqttConnectStatusListener {
    private static final Logger log = LoggerFactory.getLogger(SpringEventMqttConnectStatusListener.class);
    private final ApplicationEventPublisher eventPublisher;

    public void online(ChannelContext context, String clientId, String username) {
        log.info("Mqtt clientId:{} username:{} online.", (Object)clientId, (Object)username);
        MqttClientOnlineEvent onlineEvent = new MqttClientOnlineEvent();
        onlineEvent.setClientId(clientId);
        onlineEvent.setUsername(username);
        Node clientNode = context.getClientNode();
        onlineEvent.setIpAddress(clientNode.getIp());
        onlineEvent.setPort(clientNode.getPort());
        long keepalive = context.heartbeatTimeout == null ? 60L : TimeUnit.MILLISECONDS.toSeconds(context.heartbeatTimeout);
        onlineEvent.setKeepalive(keepalive);
        onlineEvent.setTs(context.stat.timeCreated);
        this.eventPublisher.publishEvent((Object)onlineEvent);
    }

    public void offline(ChannelContext context, String clientId, String username, String reason) {
        log.info("Mqtt clientId:{} username:{} offline reason:{}.", new Object[]{clientId, username, reason});
        MqttClientOfflineEvent offlineEvent = new MqttClientOfflineEvent();
        offlineEvent.setClientId(clientId);
        offlineEvent.setUsername(username);
        offlineEvent.setReason(reason);
        offlineEvent.setTs(context.stat.timeClosed);
        this.eventPublisher.publishEvent((Object)offlineEvent);
    }

    public SpringEventMqttConnectStatusListener(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

