/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server.event;

import java.nio.ByteBuffer;
import net.dreamlu.iot.mqtt.codec.ByteBufferUtil;
import net.dreamlu.iot.mqtt.core.server.event.IMqttMessageListener;
import net.dreamlu.iot.mqtt.core.server.model.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.tio.core.ChannelContext;

public class SpringEventMqttMessageListener
implements IMqttMessageListener {
    private static final Logger log = LoggerFactory.getLogger(SpringEventMqttMessageListener.class);
    private final ApplicationEventPublisher eventPublisher;

    public void onMessage(ChannelContext context, String clientId, Message message) {
        if (log.isDebugEnabled()) {
            log.debug("mqtt server receive message clientId:{} message:{} payload:{}", new Object[]{clientId, message, ByteBufferUtil.toString((ByteBuffer)message.getPayload())});
        }
        this.eventPublisher.publishEvent((Object)message);
    }

    public SpringEventMqttMessageListener(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

