/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server.config;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collections;
import net.dreamlu.iot.mqtt.core.server.MqttServer;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.server.ServerGroupStat;
import org.tio.server.TioServerConfig;

public class MqttServerMetrics
implements ApplicationListener<ApplicationStartedEvent> {
    public static final String MQTT_METRIC_NAME_PREFIX = "mqtt";
    private static final String MQTT_CONNECTIONS_ACCEPTED = "mqtt.connections.accepted";
    private static final String MQTT_CONNECTIONS_SIZE = "mqtt.connections.size";
    private static final String MQTT_CONNECTIONS_CLOSED = "mqtt.connections.closed";
    private static final String MQTT_MESSAGES_HANDLED_PACKETS = "mqtt.messages.handled.packets";
    private static final String MQTT_MESSAGES_HANDLED_BYTES = "mqtt.messages.handled.bytes";
    private static final String MQTT_MESSAGES_RECEIVED_PACKETS = "mqtt.messages.received.packets";
    private static final String MQTT_MESSAGES_RECEIVED_BYTES = "mqtt.messages.received.bytes";
    private static final String MQTT_MESSAGES_SEND_PACKETS = "mqtt.messages.send.packets";
    private static final String MQTT_MESSAGES_SEND_BYTES = "mqtt.messages.send.bytes";
    private final Iterable<Tag> tags;

    public MqttServerMetrics() {
        this.tags = Collections.emptyList();
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        MqttServer mqttServer = (MqttServer)applicationContext.getBean(MqttServer.class);
        MeterRegistry registry = (MeterRegistry)applicationContext.getBean(MeterRegistry.class);
        TioServerConfig serverConfig = mqttServer.getServerConfig();
        this.bindTo(registry, serverConfig);
    }

    private void bindTo(MeterRegistry meterRegistry, TioServerConfig serverConfig) {
        Gauge.builder((String)MQTT_CONNECTIONS_ACCEPTED, (Object)serverConfig, config -> ((ServerGroupStat)config.getGroupStat()).getAccepted().get()).description("Mqtt server connections accepted").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_CONNECTIONS_SIZE, (Object)serverConfig, config -> Tio.getAll((TioConfig)config).size()).description("Mqtt server connections size").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_CONNECTIONS_CLOSED, (Object)serverConfig, config -> config.getGroupStat().getClosed().get()).description("Mqtt server connections closed").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_HANDLED_PACKETS, (Object)serverConfig, config -> config.getGroupStat().getHandledPackets().get()).description("Mqtt server handled packets").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_HANDLED_BYTES, (Object)serverConfig, config -> config.getGroupStat().getHandledBytes().get()).description("Mqtt server handled bytes").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_RECEIVED_PACKETS, (Object)serverConfig, config -> config.getGroupStat().getReceivedPackets().get()).description("Mqtt server received packets").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_RECEIVED_BYTES, (Object)serverConfig, config -> config.getGroupStat().getReceivedBytes().get()).description("Mqtt server received bytes").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_SEND_PACKETS, (Object)serverConfig, config -> config.getGroupStat().getSentPackets().get()).description("Mqtt server send packets").tags(this.tags).register(meterRegistry);
        Gauge.builder((String)MQTT_MESSAGES_SEND_BYTES, (Object)serverConfig, config -> config.getGroupStat().getSentPackets().get()).description("Mqtt server send bytes").tags(this.tags).register(meterRegistry);
    }

    public MqttServerMetrics(Iterable<Tag> tags) {
        this.tags = tags;
    }
}

