/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server;

import net.dreamlu.iot.mqtt.codec.ByteBufferAllocator;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="mqtt.server")
public class MqttServerProperties {
    public static final String PREFIX = "mqtt.server";
    private boolean enabled = true;
    private String name = "Mica-Mqtt-Server";
    private String ip;
    private int port = 1883;
    private Long heartbeatTimeout;
    private float keepaliveBackoff = 0.75f;
    private int readBufferSize = 8092;
    private int maxBytesInMessage = 8092;
    private ByteBufferAllocator bufferAllocator = ByteBufferAllocator.HEAP;
    private Ssl ssl = new Ssl();
    private boolean debug = false;
    private int maxClientIdLength = 23;
    private int webPort = 8083;
    private boolean websocketEnable = true;
    private boolean httpEnable = false;
    private HttpBasicAuth httpBasicAuth = new HttpBasicAuth();
    private String nodeName;
    private boolean statEnable = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public float getKeepaliveBackoff() {
        return this.keepaliveBackoff;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public ByteBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public boolean isWebsocketEnable() {
        return this.websocketEnable;
    }

    public boolean isHttpEnable() {
        return this.httpEnable;
    }

    public HttpBasicAuth getHttpBasicAuth() {
        return this.httpBasicAuth;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHeartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setKeepaliveBackoff(float keepaliveBackoff) {
        this.keepaliveBackoff = keepaliveBackoff;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public void setMaxBytesInMessage(int maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
    }

    public void setBufferAllocator(ByteBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMaxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
    }

    public void setWebPort(int webPort) {
        this.webPort = webPort;
    }

    public void setWebsocketEnable(boolean websocketEnable) {
        this.websocketEnable = websocketEnable;
    }

    public void setHttpEnable(boolean httpEnable) {
        this.httpEnable = httpEnable;
    }

    public void setHttpBasicAuth(HttpBasicAuth httpBasicAuth) {
        this.httpBasicAuth = httpBasicAuth;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setStatEnable(boolean statEnable) {
        this.statEnable = statEnable;
    }

    public static class HttpBasicAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Ssl {
        private String keyStorePath;
        private String trustStorePath;
        private String password;

        public String getKeyStorePath() {
            return this.keyStorePath;
        }

        public String getTrustStorePath() {
            return this.trustStorePath;
        }

        public String getPassword() {
            return this.password;
        }

        public void setKeyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
        }

        public void setTrustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

