/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.server;

import net.dreamlu.iot.mqtt.core.server.MqttServer;
import net.dreamlu.iot.mqtt.core.server.MqttServerCreator;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerAuthHandler;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerPublishPermission;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import net.dreamlu.iot.mqtt.core.server.auth.IMqttServerUniqueIdService;
import net.dreamlu.iot.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import net.dreamlu.iot.mqtt.core.server.event.IMqttConnectStatusListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttMessageListener;
import net.dreamlu.iot.mqtt.core.server.event.IMqttSessionListener;
import net.dreamlu.iot.mqtt.core.server.session.IMqttSessionManager;
import net.dreamlu.iot.mqtt.core.server.store.IMqttMessageStore;
import net.dreamlu.iot.mqtt.spring.server.MqttServerCustomizer;
import net.dreamlu.iot.mqtt.spring.server.MqttServerLauncher;
import net.dreamlu.iot.mqtt.spring.server.MqttServerProperties;
import net.dreamlu.iot.mqtt.spring.server.MqttServerTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tio.core.stat.IpStatListener;
import org.tio.utils.hutool.StrUtil;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="mqtt.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttServerProperties.class})
public class MqttServerConfiguration {
    @Bean
    public MqttServerCreator mqttServerCreator(MqttServerProperties properties, ObjectProvider<IMqttServerAuthHandler> authHandlerObjectProvider, ObjectProvider<IMqttServerUniqueIdService> uniqueIdServiceObjectProvider, ObjectProvider<IMqttServerSubscribeValidator> subscribeValidatorObjectProvider, ObjectProvider<IMqttServerPublishPermission> publishPermissionObjectProvider, ObjectProvider<IMqttMessageDispatcher> messageDispatcherObjectProvider, ObjectProvider<IMqttMessageStore> messageStoreObjectProvider, ObjectProvider<IMqttSessionManager> sessionManagerObjectProvider, ObjectProvider<IMqttSessionListener> sessionListenerObjectProvider, ObjectProvider<IMqttMessageListener> messageListenerObjectProvider, ObjectProvider<IMqttConnectStatusListener> connectStatusListenerObjectProvider, ObjectProvider<IpStatListener> ipStatListenerObjectProvider, ObjectProvider<MqttServerCustomizer> customizers) {
        MqttServerCreator serverCreator = MqttServer.create().name(properties.getName()).ip(properties.getIp()).port(properties.getPort()).heartbeatTimeout(properties.getHeartbeatTimeout()).keepaliveBackoff(properties.getKeepaliveBackoff()).readBufferSize(properties.getReadBufferSize()).maxBytesInMessage(properties.getMaxBytesInMessage()).bufferAllocator(properties.getBufferAllocator()).maxClientIdLength(properties.getMaxClientIdLength()).webPort(properties.getWebPort()).websocketEnable(properties.isWebsocketEnable()).httpEnable(properties.isHttpEnable()).nodeName(properties.getNodeName()).statEnable(properties.isStatEnable());
        if (properties.isDebug()) {
            serverCreator.debug();
        }
        MqttServerProperties.HttpBasicAuth httpBasicAuth = properties.getHttpBasicAuth();
        if (serverCreator.isHttpEnable() && httpBasicAuth.isEnable()) {
            serverCreator.httpBasicAuth(httpBasicAuth.getUsername(), httpBasicAuth.getPassword());
        }
        MqttServerProperties.Ssl ssl = properties.getSsl();
        String keyStorePath = ssl.getKeyStorePath();
        String trustStorePath = ssl.getTrustStorePath();
        String password = ssl.getPassword();
        if (StrUtil.isNotBlank((CharSequence)keyStorePath) && StrUtil.isNotBlank((CharSequence)trustStorePath) && StrUtil.isNotBlank((CharSequence)password)) {
            serverCreator.useSsl(keyStorePath, trustStorePath, password);
        }
        messageListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageListener(arg_0));
        authHandlerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).authHandler(arg_0));
        uniqueIdServiceObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).uniqueIdService(arg_0));
        subscribeValidatorObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).subscribeValidator(arg_0));
        publishPermissionObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).publishPermission(arg_0));
        messageDispatcherObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageDispatcher(arg_0));
        messageStoreObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).messageStore(arg_0));
        sessionManagerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).sessionManager(arg_0));
        sessionListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).sessionListener(arg_0));
        connectStatusListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).connectStatusListener(arg_0));
        ipStatListenerObjectProvider.ifAvailable(arg_0 -> ((MqttServerCreator)serverCreator).ipStatListener(arg_0));
        customizers.ifAvailable(customizer -> customizer.customize(serverCreator));
        return serverCreator;
    }

    @Bean
    public MqttServer mqttServer(MqttServerCreator mqttServerCreator) {
        return mqttServerCreator.build();
    }

    @Bean
    public MqttServerLauncher mqttServerLauncher(MqttServer mqttServer) {
        return new MqttServerLauncher(mqttServer);
    }

    @Bean
    public MqttServerTemplate mqttServerTemplate(MqttServer mqttServer) {
        return new MqttServerTemplate(mqttServer);
    }
}

