/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util;

import java.util.List;
import net.dreamlu.iot.mqtt.codec.MqttCodecUtil;

public final class TopicUtil {
    public static void validateTopicFilter(List<String> topicFilterList) {
        for (String topicFilter : topicFilterList) {
            TopicUtil.validateTopicFilter(topicFilter);
        }
    }

    public static void validateTopicFilter(String topicFilter) throws IllegalArgumentException {
        if (topicFilter == null || topicFilter.isEmpty()) {
            throw new IllegalArgumentException("TopicFilter is blank:" + topicFilter);
        }
        char[] topicFilterChars = topicFilter.toCharArray();
        int topicFilterLength = topicFilterChars.length;
        int topicFilterIdxEnd = topicFilterLength - 1;
        for (int i = 0; i < topicFilterLength; ++i) {
            char ch = topicFilterChars[i];
            if (Character.isWhitespace(ch)) {
                throw new IllegalArgumentException("Mqtt subscribe topicFilter has white space:" + topicFilter);
            }
            if (!(ch == '#' ? i < topicFilterIdxEnd : ch == '+' && i > 0 && topicFilterChars[i - 1] != '/')) continue;
            throw new IllegalArgumentException("Mqtt subscribe topicFilter illegal:" + topicFilter);
        }
    }

    public static void validateTopicName(String topicName) throws IllegalArgumentException {
        if (topicName == null || topicName.isEmpty()) {
            throw new IllegalArgumentException("Topic is blank:" + topicName);
        }
        if (MqttCodecUtil.isTopicFilter((String)topicName)) {
            throw new IllegalArgumentException("Topic has wildcards char [+] or [#], topicName:" + topicName);
        }
    }

    public static boolean match(String topicFilter, String topicName) {
        char[] topicFilterChars = topicFilter.toCharArray();
        char[] topicNameChars = topicName.toCharArray();
        int topicFilterLength = topicFilterChars.length;
        int topicNameLength = topicNameChars.length;
        int topicFilterIdxEnd = topicFilterLength - 1;
        int topicNameIdxEnd = topicNameLength - 1;
        boolean inLayerWildcard = false;
        int wildcardCharLen = 0;
        block0: for (int i = 0; i < topicFilterLength; ++i) {
            int topicNameIdx;
            char ch = topicFilterChars[i];
            if (ch == '#') {
                if (i < topicFilterIdxEnd) {
                    throw new IllegalArgumentException("Mqtt subscribe topicFilter illegal:" + topicFilter);
                }
                return true;
            }
            if (ch == '+') {
                if (i > 0 && topicFilterChars[i - 1] != '/') {
                    throw new IllegalArgumentException("Mqtt subscribe topicFilter illegal:" + topicFilter);
                }
                topicNameIdx = i + wildcardCharLen;
                if (i == topicFilterIdxEnd && topicNameLength > topicNameIdx) {
                    for (int j = topicNameIdx; j < topicNameLength; ++j) {
                        if (topicNameChars[j] != '/') continue;
                        return false;
                    }
                    return true;
                }
                inLayerWildcard = true;
            } else if (ch == '/') {
                int next;
                if (inLayerWildcard) {
                    inLayerWildcard = false;
                }
                if (topicFilterLength > (next = i + 1) && topicFilterChars[next] == '#' && topicNameLength < next) {
                    return true;
                }
            }
            if (topicNameIdxEnd < i) {
                return false;
            }
            if (inLayerWildcard) {
                for (int j = i + wildcardCharLen; j < topicNameLength; ++j) {
                    if (topicNameChars[j] == '/') {
                        --wildcardCharLen;
                        continue block0;
                    }
                    ++wildcardCharLen;
                }
            }
            if ((topicNameIdx = i + wildcardCharLen) > topicNameIdxEnd) {
                return false;
            }
            if (ch == topicNameChars[topicNameIdx]) continue;
            return false;
        }
        return topicFilterLength + wildcardCharLen + 1 > topicNameLength;
    }

    public static String getTopicFilter(String topicTemplate) {
        return topicTemplate.replaceAll("\\$\\{[\\s\\w.]+}", "+").replaceAll("#\\{[\\s\\w.]+}", "#");
    }
}

