/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.tio.utils.thread.pool.DefaultThreadFactory;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.utils.thread.pool.TioCallerRunsPolicy;

public final class ThreadUtil {
    public static boolean sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public static ThreadPoolExecutor getGroupExecutor(int groupPoolSize) {
        String threadName = "tio-group";
        DefaultThreadFactory threadFactory = DefaultThreadFactory.getInstance((String)threadName, (Integer)10);
        LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor groupExecutor = new ThreadPoolExecutor(groupPoolSize, groupPoolSize, 0L, TimeUnit.SECONDS, runnableQueue, (ThreadFactory)threadFactory, (RejectedExecutionHandler)new TioCallerRunsPolicy());
        groupExecutor.prestartCoreThread();
        return groupExecutor;
    }

    public static SynThreadPoolExecutor getTioExecutor(int tioPoolSize) {
        String threadName = "tio-worker";
        LinkedBlockingQueue runnableQueue = new LinkedBlockingQueue();
        DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance((String)threadName, (Integer)10);
        SynThreadPoolExecutor tioExecutor = new SynThreadPoolExecutor(tioPoolSize, tioPoolSize, 0L, runnableQueue, (ThreadFactory)defaultThreadFactory, (RejectedExecutionHandler)new TioCallerRunsPolicy());
        tioExecutor.prestartCoreThread();
        return tioExecutor;
    }

    public static ThreadPoolExecutor getMqttExecutor(int poolSize) {
        String threadName = "mqtt-worker";
        LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
        DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance((String)threadName, (Integer)10);
        ThreadPoolExecutor tioExecutor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.SECONDS, runnableQueue, (ThreadFactory)defaultThreadFactory, (RejectedExecutionHandler)new TioCallerRunsPolicy());
        tioExecutor.prestartCoreThread();
        return tioExecutor;
    }
}

