/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client.config;

import java.nio.charset.StandardCharsets;
import java.util.List;
import net.dreamlu.iot.mqtt.codec.MqttTopicSubscription;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.spring.client.MqttClientSubscribeDetector;
import net.dreamlu.iot.mqtt.spring.client.MqttClientTemplate;
import net.dreamlu.iot.mqtt.spring.client.config.MqttClientProperties;
import net.dreamlu.iot.mqtt.spring.client.event.SpringEventMqttClientConnectListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="mqtt.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MqttClientProperties.class})
public class MqttClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public IMqttClientConnectListener springEventMqttClientConnectListener(ApplicationEventPublisher eventPublisher) {
        return new SpringEventMqttClientConnectListener(eventPublisher);
    }

    @Bean
    public MqttClientCreator mqttClientCreator(MqttClientProperties properties) {
        List<MqttTopicSubscription> globalSubscribe;
        MqttClientProperties.WillMessage willMessage;
        MqttClientProperties.Ssl ssl;
        MqttClientCreator clientCreator = MqttClient.create().name(properties.getName()).ip(properties.getIp()).port(properties.getPort()).username(properties.getUserName()).password(properties.getPassword()).clientId(properties.getClientId()).readBufferSize((int)properties.getReadBufferSize().toBytes()).maxBytesInMessage((int)properties.getMaxBytesInMessage().toBytes()).maxClientIdLength(properties.getMaxClientIdLength()).keepAliveSecs(properties.getKeepAliveSecs()).reconnect(properties.isReconnect()).reInterval(properties.getReInterval()).retryCount(properties.getRetryCount()).reSubscribeBatchSize(properties.getReSubscribeBatchSize()).version(properties.getVersion()).cleanSession(properties.isCleanSession()).bufferAllocator(properties.getBufferAllocator()).statEnable(properties.isStatEnable());
        Integer timeout = properties.getTimeout();
        if (timeout != null && timeout > 0) {
            clientCreator.timeout(timeout.intValue());
        }
        if (properties.isDebug()) {
            clientCreator.debug();
        }
        if ((ssl = properties.getSsl()).isEnabled()) {
            clientCreator.useSsl(ssl.getKeystorePath(), ssl.getKeystorePass(), ssl.getTruststorePath(), ssl.getTruststorePass());
        }
        if ((willMessage = properties.getWillMessage()) != null && StringUtils.hasText((String)willMessage.getTopic())) {
            clientCreator.willMessage(builder -> {
                builder.topic(willMessage.getTopic()).qos(willMessage.getQos()).retain(willMessage.isRetain());
                if (StringUtils.hasText((String)willMessage.getMessage())) {
                    builder.message(willMessage.getMessage().getBytes(StandardCharsets.UTF_8));
                }
            });
        }
        if ((globalSubscribe = properties.getGlobalSubscribe()) != null && !globalSubscribe.isEmpty()) {
            clientCreator.globalSubscribe(globalSubscribe);
        }
        return clientCreator;
    }

    @Bean(value={"mqttClientTemplate"})
    @ConditionalOnMissingBean(name={"mqttClientTemplate"})
    public MqttClientTemplate mqttClientTemplate(MqttClientCreator mqttClientCreator) {
        return new MqttClientTemplate(mqttClientCreator);
    }

    @Bean
    public MqttClientSubscribeDetector mqttClientSubscribeDetector(ApplicationContext applicationContext) {
        return new MqttClientSubscribeDetector(applicationContext);
    }
}

