/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.dreamlu.iot.mqtt.codec.MqttMessageBuilders;
import net.dreamlu.iot.mqtt.codec.MqttProperties;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.core.client.DefaultMqttClientSession;
import net.dreamlu.iot.mqtt.core.client.IMqttClientConnectListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientGlobalMessageListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.client.IMqttClientSession;
import net.dreamlu.iot.mqtt.core.client.MqttClient;
import net.dreamlu.iot.mqtt.core.client.MqttClientCreator;
import net.dreamlu.iot.mqtt.core.client.MqttClientSubscription;
import net.dreamlu.iot.mqtt.spring.client.MqttClientCustomizer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.tio.client.ClientChannelContext;
import org.tio.client.TioClient;
import org.tio.client.TioClientConfig;
import org.tio.utils.timer.TimerTask;

public class MqttClientTemplate
implements ApplicationContextAware,
SmartInitializingSingleton,
InitializingBean,
DisposableBean,
Ordered {
    public static final String DEFAULT_CLIENT_TEMPLATE_BEAN = "mqttClientTemplate";
    private final MqttClientCreator clientCreator;
    private ApplicationContext applicationContext;
    private MqttClient client;

    public MqttClientTemplate(MqttClientCreator clientCreator) {
        this.clientCreator = clientCreator;
    }

    public MqttClient subQos0(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.QOS0, listener);
    }

    public MqttClient subQos1(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.QOS1, listener);
    }

    public MqttClient subQos2(String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, MqttQoS.QOS2, listener);
    }

    public MqttClient subscribe(MqttQoS mqttQoS, String topicFilter, IMqttClientMessageListener listener) {
        return this.client.subscribe(mqttQoS, topicFilter, listener);
    }

    public MqttClient subscribe(String topicFilter, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilter, mqttQoS, listener);
    }

    public MqttClient subscribe(String topicFilter, MqttQoS mqttQoS, IMqttClientMessageListener listener, MqttProperties properties) {
        return this.client.subscribe(topicFilter, mqttQoS, listener, properties);
    }

    public MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener) {
        return this.client.subscribe(topicFilters, mqttQoS, listener);
    }

    public MqttClient subscribe(String[] topicFilters, MqttQoS mqttQoS, IMqttClientMessageListener listener, MqttProperties properties) {
        return this.client.subscribe(topicFilters, mqttQoS, listener, properties);
    }

    public MqttClient subscribe(List<MqttClientSubscription> subscriptionList) {
        return this.client.subscribe(subscriptionList);
    }

    public MqttClient subscribe(List<MqttClientSubscription> subscriptionList, MqttProperties properties) {
        return this.client.subscribe(subscriptionList, properties);
    }

    public MqttClient unSubscribe(String ... topicFilters) {
        return this.client.unSubscribe(topicFilters);
    }

    public MqttClient unSubscribe(List<String> topicFilters) {
        return this.client.unSubscribe(topicFilters);
    }

    public boolean publish(String topic, byte[] payload) {
        return this.client.publish(topic, payload, MqttQoS.QOS0);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos) {
        return this.client.publish(topic, payload, qos);
    }

    public boolean publish(String topic, byte[] payload, boolean retain) {
        return this.client.publish(topic, payload, retain);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos, boolean retain) {
        return this.client.publish(topic, payload, qos, retain);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos, boolean retain, MqttProperties properties) {
        return this.client.publish(topic, payload, qos, retain, properties);
    }

    public boolean publish(String topic, byte[] payload, MqttQoS qos, Consumer<MqttMessageBuilders.PublishBuilder> builder) {
        return this.client.publish(topic, payload, qos, builder);
    }

    public TimerTask schedule(Runnable command, long delay) {
        return this.client.schedule(command, delay);
    }

    public TimerTask schedule(Runnable command, long delay, Executor executor) {
        return this.client.schedule(command, delay, executor);
    }

    public TimerTask scheduleOnce(Runnable command, long delay) {
        return this.client.scheduleOnce(command, delay);
    }

    public TimerTask scheduleOnce(Runnable command, long delay, Executor executor) {
        return this.client.scheduleOnce(command, delay, executor);
    }

    public void reconnect() {
        this.client.reconnect();
    }

    public boolean reconnect(String ip, int port) {
        return this.client.reconnect(ip, port);
    }

    public boolean disconnect() {
        return this.client.disconnect();
    }

    public TioClient getTioClient() {
        return this.client.getTioClient();
    }

    public TioClientConfig getClientTioConfig() {
        return this.client.getClientTioConfig();
    }

    public ClientChannelContext getContext() {
        return this.client.getContext();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public boolean isDisconnected() {
        return this.client.isDisconnected();
    }

    public MqttClient getMqttClient() {
        return this.client;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        IMqttClientSession clientSession = this.clientCreator.getClientSession();
        if (clientSession == null) {
            clientSession = (IMqttClientSession)this.applicationContext.getBeanProvider(IMqttClientSession.class).getIfAvailable(DefaultMqttClientSession::new);
            this.clientCreator.clientSession(clientSession);
        }
    }

    public void afterSingletonsInstantiated() {
        this.applicationContext.getBeanProvider(IMqttClientConnectListener.class).ifAvailable(arg_0 -> ((MqttClientCreator)this.clientCreator).connectListener(arg_0));
        this.applicationContext.getBeanProvider(IMqttClientGlobalMessageListener.class).ifAvailable(arg_0 -> ((MqttClientCreator)this.clientCreator).globalMessageListener(arg_0));
        this.applicationContext.getBeanProvider(MqttClientCustomizer.class).ifAvailable(customizer -> customizer.customize(this.clientCreator));
        Integer timeout = this.clientCreator.getTimeout();
        if (timeout == null) {
            this.clientCreator.timeout(3);
        }
        this.client = this.clientCreator.connectSync();
    }

    public void destroy() {
        this.client.stop();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public MqttClientCreator getClientCreator() {
        return this.clientCreator;
    }
}

