/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client.config;

import net.dreamlu.iot.mqtt.codec.ByteBufferAllocator;
import net.dreamlu.iot.mqtt.codec.MqttQoS;
import net.dreamlu.iot.mqtt.codec.MqttVersion;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="mqtt.client")
public class MqttClientProperties {
    public static final String PREFIX = "mqtt.client";
    private boolean enabled = false;
    private String name = "Mica-Mqtt-Client";
    private String ip = "127.0.0.1";
    private int port = 1883;
    private String userName;
    private String password;
    private String clientId;
    private Integer timeout;
    private DataSize readBufferSize = DataSize.ofBytes((long)8192L);
    private DataSize maxBytesInMessage = DataSize.ofBytes((long)0xA00000L);
    private int maxClientIdLength = 64;
    private int keepAliveSecs = 60;
    private boolean reconnect = true;
    private long reInterval = 5000L;
    private int retryCount = 0;
    private int reSubscribeBatchSize = 20;
    private MqttVersion version = MqttVersion.MQTT_3_1_1;
    private boolean cleanSession = true;
    private ByteBufferAllocator bufferAllocator = ByteBufferAllocator.HEAP;
    private WillMessage willMessage;
    private boolean statEnable = false;
    private boolean debug = false;
    private Ssl ssl = new Ssl();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public DataSize getReadBufferSize() {
        return this.readBufferSize;
    }

    public DataSize getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public int getKeepAliveSecs() {
        return this.keepAliveSecs;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public long getReInterval() {
        return this.reInterval;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getReSubscribeBatchSize() {
        return this.reSubscribeBatchSize;
    }

    public MqttVersion getVersion() {
        return this.version;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public ByteBufferAllocator getBufferAllocator() {
        return this.bufferAllocator;
    }

    public WillMessage getWillMessage() {
        return this.willMessage;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setReadBufferSize(DataSize readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public void setMaxBytesInMessage(DataSize maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
    }

    public void setMaxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
    }

    public void setKeepAliveSecs(int keepAliveSecs) {
        this.keepAliveSecs = keepAliveSecs;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public void setReInterval(long reInterval) {
        this.reInterval = reInterval;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setReSubscribeBatchSize(int reSubscribeBatchSize) {
        this.reSubscribeBatchSize = reSubscribeBatchSize;
    }

    public void setVersion(MqttVersion version) {
        this.version = version;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public void setBufferAllocator(ByteBufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
    }

    public void setWillMessage(WillMessage willMessage) {
        this.willMessage = willMessage;
    }

    public void setStatEnable(boolean statEnable) {
        this.statEnable = statEnable;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public static class Ssl {
        private boolean enabled = false;
        private String keystorePath;
        private String keystorePass;
        private String truststorePath;
        private String truststorePass;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public String getKeystorePass() {
            return this.keystorePass;
        }

        public String getTruststorePath() {
            return this.truststorePath;
        }

        public String getTruststorePass() {
            return this.truststorePass;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
        }

        public void setKeystorePass(String keystorePass) {
            this.keystorePass = keystorePass;
        }

        public void setTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
        }

        public void setTruststorePass(String truststorePass) {
            this.truststorePass = truststorePass;
        }
    }

    public static class WillMessage {
        private String topic;
        private MqttQoS qos = MqttQoS.AT_MOST_ONCE;
        private String message;
        private boolean retain = false;

        public String getTopic() {
            return this.topic;
        }

        public MqttQoS getQos() {
            return this.qos;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isRetain() {
            return this.retain;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setQos(MqttQoS qos) {
            this.qos = qos;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setRetain(boolean retain) {
            this.retain = retain;
        }
    }
}

