/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.spring.client;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.dreamlu.iot.mqtt.core.client.IMqttClientMessageListener;
import net.dreamlu.iot.mqtt.core.util.TopicUtil;
import net.dreamlu.iot.mqtt.spring.client.MqttClientSubscribe;
import net.dreamlu.iot.mqtt.spring.client.MqttClientTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MqttClientSubscribeDetector
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(MqttClientSubscribeDetector.class);
    private final ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        Class userClass = ClassUtils.getUserClass((Object)bean);
        if (bean instanceof IMqttClientMessageListener) {
            MqttClientSubscribe subscribe = (MqttClientSubscribe)AnnotationUtils.findAnnotation((Class)userClass, MqttClientSubscribe.class);
            if (subscribe != null) {
                MqttClientTemplate clientTemplate = MqttClientSubscribeDetector.getMqttClientTemplate(this.applicationContext, subscribe.clientTemplateBean());
                String[] topicFilters = MqttClientSubscribeDetector.getTopicFilters(this.applicationContext, subscribe.value());
                clientTemplate.addSubscriptionList(topicFilters, subscribe.qos(), (IMqttClientMessageListener)bean);
            }
        } else {
            ReflectionUtils.doWithMethods((Class)userClass, method -> {
                MqttClientSubscribe subscribe = (MqttClientSubscribe)AnnotationUtils.findAnnotation((Method)method, MqttClientSubscribe.class);
                if (subscribe != null) {
                    int modifiers = method.getModifiers();
                    if (Modifier.isStatic(modifiers)) {
                        throw new IllegalArgumentException("@MqttClientSubscribe on method " + method + " must not static.");
                    }
                    if (!Modifier.isPublic(modifiers)) {
                        throw new IllegalArgumentException("@MqttClientSubscribe on method " + method + " must public.");
                    }
                    int paramCount = method.getParameterCount();
                    if (paramCount != 2) {
                        throw new IllegalArgumentException("@MqttClientSubscribe on method " + method + " parameter count must equal to 2.");
                    }
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    Class<?> topicParamType = parameterTypes[0];
                    Class<?> payloadParamType = parameterTypes[1];
                    if (String.class != topicParamType || ByteBuffer.class != payloadParamType) {
                        throw new IllegalArgumentException("@MqttClientSubscribe on method " + method + " parameter type must String and ByteBuffer.");
                    }
                    MqttClientTemplate clientTemplate = MqttClientSubscribeDetector.getMqttClientTemplate(this.applicationContext, subscribe.clientTemplateBean());
                    String[] topicFilters = MqttClientSubscribeDetector.getTopicFilters(this.applicationContext, subscribe.value());
                    clientTemplate.addSubscriptionList(topicFilters, subscribe.qos(), (context, topic, message, payload) -> ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{topic, payload}));
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return bean;
    }

    private static MqttClientTemplate getMqttClientTemplate(ApplicationContext applicationContext, String beanName) {
        return (MqttClientTemplate)applicationContext.getBean(beanName, MqttClientTemplate.class);
    }

    private static String[] getTopicFilters(ApplicationContext applicationContext, String[] values) {
        return (String[])Arrays.stream(values).map(arg_0 -> ((Environment)applicationContext.getEnvironment()).resolvePlaceholders(arg_0)).map(TopicUtil::getTopicFilter).toArray(String[]::new);
    }

    public MqttClientSubscribeDetector(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

