/*
 * Decompiled with CFR 0.152.
 */
package net.dontcode.core;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.dontcode.core.Change;
import net.dontcode.core.DontCodeModelPointer;
import net.dontcode.core.MapOrString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Models {
    private static Logger log = LoggerFactory.getLogger(Models.class);

    public static MapOrString applyChange(MapOrString orig, Change toApply) {
        String parentPosition = DontCodeModelPointer.parentPositionOf(toApply.position);
        MapOrString curContent = Models.findAtPosition(orig, parentPosition, false);
        if (curContent == null) {
            if (toApply.type == Change.ChangeType.DELETE) {
                return orig;
            }
            curContent = Models.findAtPosition(orig, parentPosition, true);
        }
        if (toApply.type == Change.ChangeType.MOVE && toApply.oldPosition == null && toApply.value == null) {
            log.warn("Cannot apply MOVE Change without value or oldPosition for {}", (Object)toApply.position);
            return orig;
        }
        if (toApply.value != null || toApply.type == Change.ChangeType.MOVE || toApply.type == Change.ChangeType.DELETE) {
            Models.recursiveApplyChange(orig, toApply, curContent, MapOrString.fromObject(toApply.value), DontCodeModelPointer.lastElementOf(toApply.position), true);
        } else {
            log.warn("Missing a value to non MOVE or DELETE change for {}", (Object)toApply.position);
        }
        return orig;
    }

    public static Map<String, Object> applyChange(Map<String, Object> orig, Change toApply) {
        if (toApply == null || orig == null) {
            return orig;
        }
        return Models.applyChange(new MapOrString(orig), toApply).getMap();
    }

    public static MapOrString findAtPosition(MapOrString src, String position, boolean create) {
        Object result = Models.findAtPosition(src.getMap(), position, create);
        return MapOrString.fromObject(result);
    }

    public static Object findAtPosition(Map<String, Object> src, String position, boolean create) {
        if (position == null || position.length() == 0 || src == null) {
            return src;
        }
        String[] path = position.split("/");
        LinkedHashMap cur = src;
        for (int i = 0; i < path.length; ++i) {
            String elt = path[i];
            if (cur.get(elt) instanceof Map) {
                cur = (LinkedHashMap)cur.get(elt);
                continue;
            }
            if (cur.get(elt) instanceof String && i == path.length - 1) {
                return cur.get(elt);
            }
            if (!create) {
                return null;
            }
            LinkedHashMap newOne = new LinkedHashMap();
            cur.put(elt, newOne);
            cur = newOne;
        }
        return cur;
    }

    protected static void recursiveApplyChange(MapOrString orig, Change toApply, MapOrString oldContent, MapOrString newContent, String position, boolean isRoot) {
        if (position.indexOf(47) != -1) {
            throw new RuntimeException("Position must be single element");
        }
        MapOrString curContent = position.length() == 0 ? oldContent : MapOrString.fromObject(oldContent.mapGet(position));
        switch (toApply.type) {
            case ADD: 
            case UPDATE: 
            case MOVE: 
            case RESET: {
                if (toApply.type == Change.ChangeType.MOVE && (newContent == null || newContent.isNull())) {
                    newContent = Models.findAtPosition(orig, toApply.getOldPosition(), false);
                }
                if (curContent != null) {
                    if (curContent.isString() || newContent == null || newContent.isString()) {
                        if (isRoot) {
                            oldContent.mapInsert(position, newContent.getMapOrStringValue(), toApply.beforeKey);
                            break;
                        }
                        oldContent.mapInsert(position, newContent.getMapOrStringValue(), null);
                        break;
                    }
                    HashSet<String> toRemove = new HashSet<String>(curContent.getMap().keySet());
                    newContent.getMap().entrySet().forEach(newItem -> {
                        toRemove.remove(newItem.getKey());
                        if (newItem.getValue() != curContent.mapGet((String)newItem.getKey())) {
                            Models.recursiveApplyChange(orig, toApply, curContent, MapOrString.fromObject(newItem.getValue()), (String)newItem.getKey(), false);
                        }
                    });
                    if (toApply.type.equals((Object)Change.ChangeType.RESET) || toApply.type.equals((Object)Change.ChangeType.UPDATE)) {
                        toRemove.forEach(s -> curContent.getMap().remove(s));
                    }
                    if (!isRoot || !toApply.type.equals((Object)Change.ChangeType.MOVE) && toApply.beforeKey == null) break;
                    oldContent.mapInsert(position, newContent.getMapOrStringValue(), toApply.beforeKey);
                    break;
                }
                oldContent.mapInsert(position, newContent.getMapOrStringValue(), toApply.beforeKey);
                if (toApply.type != Change.ChangeType.MOVE) break;
                MapOrString parent = Models.findAtPosition(orig, DontCodeModelPointer.parentPositionOf(toApply.getOldPosition()), false);
                parent.mapRemove(DontCodeModelPointer.lastElementOf(toApply.getOldPosition()));
                break;
            }
            case DELETE: {
                if (curContent == null) break;
                oldContent.mapRemove(position);
            }
        }
    }
}

