/*
 * Decompiled with CFR 0.152.
 */
package net.dontcode.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class MapOrString {
    protected Map<String, Object> map;
    protected String string;

    public MapOrString() {
        this.map = new LinkedHashMap<String, Object>();
    }

    public MapOrString(Map<String, Object> map) {
        this.map = map;
    }

    public MapOrString(String string) {
        this.string = string;
    }

    public Object getMapOrStringValue() {
        return this.map == null ? this.string : this.map;
    }

    public static MapOrString fromObject(Object from) {
        if (from instanceof String) {
            return new MapOrString((String)from);
        }
        if (from instanceof MapOrString) {
            return (MapOrString)from;
        }
        if (from instanceof Map) {
            return new MapOrString((Map)from);
        }
        if (from == null) {
            return null;
        }
        throw new RuntimeException("Cannot create a MapOrString from object of class " + from.getClass().getName());
    }

    public boolean isMap() {
        return this.map != null;
    }

    public boolean isString() {
        return this.string != null;
    }

    public boolean isNull() {
        return this.string == null && (this.map == null || this.map.size() == 0);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public boolean mapContainsKey(String key) {
        if (this.map != null) {
            return this.map.containsKey(key);
        }
        throw new RuntimeException("Not a map");
    }

    public MapOrString find(String toFind) {
        String[] positions = toFind.split("/");
        Map cur = this.getMap();
        for (int i = 0; i < positions.length; ++i) {
            String nextPos = positions[i];
            Object child = cur.get(nextPos);
            if (!(child instanceof Map)) {
                if (i < positions.length - 1) {
                    return null;
                }
                return MapOrString.fromObject(child);
            }
            cur = (Map)child;
        }
        return MapOrString.fromObject(cur);
    }

    public Object mapGet(String key) {
        if (this.map != null) {
            return this.map.get(key);
        }
        throw new RuntimeException("Not a map");
    }

    public Optional<Map<String, Object>> mapGetMap(String key) {
        Object ret = this.mapGet(key);
        if (ret instanceof Map) {
            return Optional.of((Map)ret);
        }
        return Optional.empty();
    }

    public void mapPut(String key, Object val) {
        if (this.map == null) {
            throw new RuntimeException("Not a map");
        }
        this.map.put(key, val);
    }

    public void mapInsert(String key, Object val, String beforeKey) {
        if (beforeKey == null) {
            this.mapRemove(key);
            this.mapPut(key, val);
        } else if (this.map != null) {
            LinkedHashMap newMap = new LinkedHashMap();
            this.map.entrySet().forEach(stringMapOrStringEntry -> {
                if (beforeKey.equals(stringMapOrStringEntry.getKey())) {
                    newMap.put(key, val);
                }
                if (!key.equals(stringMapOrStringEntry.getKey())) {
                    newMap.put((String)stringMapOrStringEntry.getKey(), stringMapOrStringEntry.getValue());
                }
            });
            this.map.clear();
            this.map.putAll(newMap);
        } else {
            throw new RuntimeException("Not a map");
        }
    }

    public void mapRemove(String key) {
        if (this.map == null) {
            throw new RuntimeException("Not a map");
        }
        this.map.remove(key);
    }

    public String getString() {
        return this.string;
    }
}

