package net.donky.core.messaging.rich.inbox.ui;

import net.donky.core.messaging.ui.notifications.RichMessagePushUIConfiguration;

/**
 * Configuration with Activities classes that should be launched when user taps remote notifications
 *
 * Created by Marcin Swierczek
 * 28/07/2015.
 * Copyright (C) Donky Networks Ltd. All rights reserved.
 */
public class PushConfiguration {

    Class<?> inboxActivity;

    Class<?> messageActivity;

    RichMessagePushUIConfiguration uiConfig;

    /**
     * Recommended constructor.
     *
     * @param inboxActivity   Activity class that implements inbox functionality
     * @param messageActivity Activity class that implements message screen functionality
     */
    public PushConfiguration(Class<?> inboxActivity, Class<?> messageActivity) {
        this.inboxActivity = inboxActivity;
        this.messageActivity = messageActivity;
    }

    /**
     * Constructor.
     */
    public PushConfiguration(RichMessagePushUIConfiguration uiConfig) {
        this.inboxActivity = null;
        this.messageActivity = null;
        this.uiConfig = uiConfig;
    }

    /**
     * Constructor.
     */
    public PushConfiguration(Class<?> inboxActivity, Class<?> messageActivity, RichMessagePushUIConfiguration uiConfig) {
        this.inboxActivity = inboxActivity;
        this.messageActivity = messageActivity;
        this.uiConfig = uiConfig;
    }

    /**
     * Get Activity that implements inbox functionality
     *
     * @return Activity class that implements inbox functionality
     */
    public Class<?> getInboxActivity() {
        return inboxActivity;
    }

    /**
     * Get Activity that implements message screen functionality
     *
     * @return Activity class that implements message screen functionality
     */
    public Class<?> getMessageActivity() {
        return messageActivity;
    }

    /**
     * Get configuration for ui push notification.
     *
     * @return Configuration for ui push notification.
     */
    public RichMessagePushUIConfiguration getUiConfig() {
        return uiConfig;
    }

    /**
     * Set configuration for ui push notification.
     *
     * @param uiConfig Configuration for ui push notification.
     */
    public void setUiConfig(RichMessagePushUIConfiguration uiConfig) {
        this.uiConfig = uiConfig;
    }
}
