/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.xhttp.json.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.dongliu.xhttp.json.JsonProcessor;

public class JacksonJsonProcessor
extends JsonProcessor {
    private final ObjectMapper objectMapper;

    public JacksonJsonProcessor() {
        this(JacksonJsonProcessor.createDefault());
    }

    private static ObjectMapper createDefault() {
        return new ObjectMapper().findAndRegisterModules();
    }

    public JacksonJsonProcessor(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public void marshal(Object value, OutputStream out, Charset charset) throws IOException {
        if (charset.equals(StandardCharsets.UTF_8)) {
            this.objectMapper.writeValue(out, value);
        } else {
            this.objectMapper.writeValue((Writer)new OutputStreamWriter(out, charset), value);
        }
    }

    public <T> T unmarshal(InputStream in, Charset charset, Type type) throws IOException {
        Objects.requireNonNull(in);
        Objects.requireNonNull(charset);
        Objects.requireNonNull(type);
        if (this.isJsonCharset(charset)) {
            try (InputStream inputStream = in;){
                JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
                Object object = this.objectMapper.readValue(in, javaType);
                return (T)object;
            }
        }
        try (InputStream inputStream = in;){
            Object object;
            try (InputStreamReader reader = new InputStreamReader(in, charset);){
                JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
                object = this.objectMapper.readValue((Reader)reader, javaType);
            }
            return (T)object;
        }
    }

    private boolean isJsonCharset(Charset charset) {
        return charset.equals(StandardCharsets.UTF_8) || charset.equals(StandardCharsets.UTF_16) || charset.equals(StandardCharsets.US_ASCII);
    }
}

