/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.xhttp.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.core.async.ByteBufferFeeder;
import com.fasterxml.jackson.core.json.async.NonBlockingJsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;

class JacksonAsyncJsonNodeDeserializer {
    private final DeserializationConfig deserializationConfig;
    private final NonBlockingJsonParser parser;
    private final ByteBufferFeeder feeder;
    private final Deque<JsonNode> stack = new ArrayDeque<JsonNode>();
    private String fieldName;
    private JsonNode rootNode;

    JacksonAsyncJsonNodeDeserializer(ObjectMapper mapper) throws IOException {
        this.deserializationConfig = mapper.getDeserializationConfig();
        JsonFactory jsonFactory = mapper.getFactory();
        this.parser = (NonBlockingJsonParser)jsonFactory.createNonBlockingByteArrayParser();
        ByteArrayFeeder byteArrayFeeder = this.parser.getNonBlockingInputFeeder();
        this.feeder = new DelegateByteBufferFeeder(byteArrayFeeder);
    }

    public void feed(ByteBuffer buffer) throws IOException {
        Objects.requireNonNull(buffer);
        if (this.rootNode != null) {
            throw new IOException("json stream already end");
        }
        boolean consumed = false;
        while (!consumed) {
            JsonToken token;
            if (this.feeder.needMoreInput()) {
                this.feeder.feedInput(buffer);
                consumed = true;
            }
            while ((token = this.parser.nextToken()) != null && token != JsonToken.NOT_AVAILABLE) {
                this.buildTree(token);
            }
        }
    }

    public JsonNode complete() throws IOException {
        JsonToken token;
        this.feeder.endOfInput();
        while ((token = this.parser.nextToken()) != null && token != JsonToken.NOT_AVAILABLE) {
            this.buildTree(token);
        }
        if (this.rootNode == null) {
            throw new IOException("unexpected end of json stream");
        }
        return this.rootNode;
    }

    private void buildTree(JsonToken token) throws IOException {
        switch (token) {
            case NOT_AVAILABLE: {
                break;
            }
            case START_OBJECT: {
                this.onStartObject();
                break;
            }
            case END_OBJECT: {
                this.onEndObject();
                break;
            }
            case START_ARRAY: {
                this.onStartArray();
                break;
            }
            case END_ARRAY: {
                this.onEndArray();
                break;
            }
            case FIELD_NAME: {
                this.fieldName = this.parser.getCurrentName();
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                break;
            }
            case VALUE_STRING: {
                this.onStringValue();
                break;
            }
            case VALUE_NUMBER_INT: {
                this.onIntValue();
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                this.onFloatValue();
                break;
            }
            case VALUE_TRUE: {
                this.onBooleanValue(true);
                break;
            }
            case VALUE_FALSE: {
                this.onBooleanValue(false);
                break;
            }
            case VALUE_NULL: {
                this.onNullValue();
            }
        }
    }

    private void onStartObject() throws IOException {
        JsonNode parent = this.stack.peek();
        if (parent == null) {
            ObjectNode node = this.nodeFactory().objectNode();
            this.stack.push((JsonNode)node);
        } else if (parent instanceof ObjectNode) {
            String name = this.consumeFieldName();
            ObjectNode node = ((ObjectNode)parent).putObject(name);
            this.stack.push((JsonNode)node);
        } else if (parent instanceof ArrayNode) {
            ObjectNode node = ((ArrayNode)parent).addObject();
            this.stack.push((JsonNode)node);
        } else {
            this.throwIllegalParent(parent);
        }
    }

    private void onEndObject() throws IOException {
        if (this.stack.isEmpty()) {
            this.setRoot((JsonNode)this.nodeFactory().objectNode());
        } else {
            JsonNode node = this.stack.pop();
            if (this.stack.isEmpty()) {
                this.setRoot(node);
            }
        }
    }

    private void onStartArray() throws IOException {
        JsonNode parent = this.stack.peek();
        if (parent == null) {
            ArrayNode node = this.nodeFactory().arrayNode();
            this.stack.push((JsonNode)node);
        } else if (parent instanceof ObjectNode) {
            String name = this.consumeFieldName();
            ArrayNode node = ((ObjectNode)parent).putArray(name);
            this.stack.push((JsonNode)node);
        } else if (parent instanceof ArrayNode) {
            ArrayNode node = ((ArrayNode)parent).addArray();
            this.stack.push((JsonNode)node);
        } else {
            this.throwIllegalParent(parent);
        }
    }

    private void onEndArray() throws IOException {
        if (this.stack.isEmpty()) {
            this.setRoot((JsonNode)this.nodeFactory().arrayNode());
        } else {
            JsonNode node = this.stack.pop();
            if (this.stack.isEmpty()) {
                this.setRoot(node);
            }
        }
    }

    private void onStringValue() throws IOException {
        String text = this.parser.getText();
        JsonNode parent = this.stack.peek();
        if (parent == null) {
            this.setRoot((JsonNode)this.nodeFactory().textNode(text));
        } else if (parent instanceof ObjectNode) {
            String name = this.consumeFieldName();
            ((ObjectNode)parent).put(name, text);
        } else if (parent instanceof ArrayNode) {
            ((ArrayNode)parent).add(text);
        } else {
            this.throwIllegalParent(parent);
        }
    }

    private void onIntValue() throws IOException {
        JsonNode parent = this.stack.peek();
        if (parent == null) {
            this.setRoot(this.fromInt());
        } else if (parent instanceof ObjectNode) {
            String name = this.consumeFieldName();
            ((ObjectNode)parent).set(name, this.fromInt());
        } else if (parent instanceof ArrayNode) {
            ((ArrayNode)parent).add(this.fromInt());
        } else {
            this.throwIllegalParent(parent);
        }
    }

    protected final JsonNode fromInt() throws IOException {
        int feats = this.deserializationFeatures();
        JsonParser.NumberType nt = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(feats) ? JsonParser.NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(feats) ? JsonParser.NumberType.LONG : this.parser.getNumberType());
        if (nt == JsonParser.NumberType.INT) {
            return this.nodeFactory().numberNode(this.parser.getIntValue());
        }
        if (nt == JsonParser.NumberType.LONG) {
            return this.nodeFactory().numberNode(this.parser.getLongValue());
        }
        return this.nodeFactory().numberNode(this.parser.getBigIntegerValue());
    }

    private void onFloatValue() throws IOException {
        JsonNode parent = this.stack.peek();
        if (parent == null) {
            this.setRoot(this.fromFloat());
        } else if (parent instanceof ObjectNode) {
            String name = this.consumeFieldName();
            ((ObjectNode)parent).set(name, this.fromFloat());
        } else if (parent instanceof ArrayNode) {
            ((ArrayNode)parent).add(this.fromFloat());
        } else {
            this.throwIllegalParent(parent);
        }
    }

    protected final JsonNode fromFloat() throws IOException {
        JsonParser.NumberType nt = this.parser.getNumberType();
        if (nt == JsonParser.NumberType.BIG_DECIMAL) {
            return this.nodeFactory().numberNode(this.parser.getDecimalValue());
        }
        int feats = this.deserializationFeatures();
        if (DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS.enabledIn(feats)) {
            if (this.parser.isNaN()) {
                return this.nodeFactory().numberNode(this.parser.getDoubleValue());
            }
            return this.nodeFactory().numberNode(this.parser.getDecimalValue());
        }
        if (nt == JsonParser.NumberType.FLOAT) {
            return this.nodeFactory().numberNode(this.parser.getFloatValue());
        }
        return this.nodeFactory().numberNode(this.parser.getDoubleValue());
    }

    private void onBooleanValue(boolean value) throws IOException {
        JsonNode parent = this.stack.peek();
        if (parent == null) {
            this.setRoot((JsonNode)this.nodeFactory().booleanNode(value));
        } else if (parent instanceof ObjectNode) {
            String name = this.consumeFieldName();
            ((ObjectNode)parent).put(name, value);
        } else if (parent instanceof ArrayNode) {
            ((ArrayNode)parent).add(value);
        } else {
            this.throwIllegalParent(parent);
        }
    }

    private void onNullValue() throws IOException {
        JsonNode parent = this.stack.peek();
        if (parent == null) {
            this.setRoot((JsonNode)this.nodeFactory().nullNode());
        } else if (parent instanceof ObjectNode) {
            String name = this.consumeFieldName();
            ((ObjectNode)parent).putNull(name);
        } else if (parent instanceof ArrayNode) {
            ((ArrayNode)parent).addNull();
        } else {
            this.throwIllegalParent(parent);
        }
    }

    private void setRoot(JsonNode node) throws IOException {
        if (this.rootNode != null) {
            throw new IOException("already has root node");
        }
        this.rootNode = node;
    }

    private String consumeFieldName() {
        String name = Objects.requireNonNull(this.fieldName);
        this.fieldName = null;
        return name;
    }

    private JsonNodeFactory nodeFactory() {
        return this.deserializationConfig.getNodeFactory();
    }

    private int deserializationFeatures() {
        return this.deserializationConfig.getDeserializationFeatures();
    }

    private void throwIllegalParent(JsonNode parent) throws IOException {
        throw new IOException("parent node is not array or object, but: " + parent.getNodeType());
    }

    private static class DelegateByteBufferFeeder
    implements ByteBufferFeeder {
        private final ByteArrayFeeder byteArrayFeeder;

        private DelegateByteBufferFeeder(ByteArrayFeeder byteArrayFeeder) {
            this.byteArrayFeeder = byteArrayFeeder;
        }

        public void feedInput(ByteBuffer buffer) throws IOException {
            if (buffer.hasArray()) {
                this.byteArrayFeeder.feedInput(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit());
            } else {
                byte[] array = new byte[buffer.remaining()];
                buffer.get(array);
                this.byteArrayFeeder.feedInput(array, 0, array.length);
            }
        }

        public boolean needMoreInput() {
            return this.byteArrayFeeder.needMoreInput();
        }

        public void endOfInput() {
            this.byteArrayFeeder.endOfInput();
        }
    }
}

