/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.xhttp.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import net.dongliu.xhttp.AsyncResponseHandler;
import net.dongliu.xhttp.ContentType;
import net.dongliu.xhttp.MimeType;
import net.dongliu.xhttp.ResponseHandler;
import net.dongliu.xhttp.body.AbstractBody;
import net.dongliu.xhttp.body.Body;
import net.dongliu.xhttp.json.ByteBuffersInputStream;
import net.dongliu.xhttp.json.TypeToken;

public abstract class JsonProcessor {
    protected abstract void marshal(Object var1, OutputStream var2, Charset var3) throws IOException;

    protected abstract <T> T unmarshal(InputStream var1, Charset var2, Type var3) throws IOException;

    public <T> Body<T> jsonBody(T value) {
        return new JsonBody<T>(value);
    }

    public <T> Body<T> jsonBody(T value, Charset charset) {
        return new JsonBody<T>(value, charset);
    }

    public <T> ResponseHandler<T> responseHandler(Class<T> type) {
        return this.responseHandler((Type)type);
    }

    public <T> ResponseHandler<T> responseHandler(TypeToken<T> type) {
        return this.responseHandler(type.getType());
    }

    private <T> ResponseHandler<T> responseHandler(Type type) {
        return (charset, info) -> this.unmarshal(info.body(), (Charset)charset.get(), type);
    }

    public <T> AsyncResponseHandler<T> asyncResponseHandler(TypeToken<T> typeToken) {
        return this.asyncResponseHandler(typeToken.getType());
    }

    public <T> AsyncResponseHandler<T> asyncResponseHandler(Class<T> cls) {
        return this.asyncResponseHandler((Type)cls);
    }

    protected <T> AsyncResponseHandler<T> asyncResponseHandler(Type type) {
        Objects.requireNonNull(type);
        return (charset, info) -> {
            JsonBodySubscriber bodySubscriber = new JsonBodySubscriber((Charset)charset.get(), type);
            info.body().subscribe(bodySubscriber);
            return bodySubscriber.getBody().toCompletableFuture();
        };
    }

    private class JsonBodySubscriber<T>
    implements HttpResponse.BodySubscriber<T> {
        private final CompletableFuture<T> future;
        private final Charset charset;
        private final Type type;
        private Flow.Subscription subscription;
        private final List<ByteBuffer> buffers;

        public JsonBodySubscriber(Charset charset, Type type) {
            this.charset = charset;
            this.type = type;
            this.future = new CompletableFuture();
            this.buffers = new ArrayList<ByteBuffer>();
        }

        @Override
        public CompletionStage<T> getBody() {
            return this.future;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            this.buffers.addAll(item);
            this.subscription.request(1L);
        }

        @Override
        public void onError(Throwable throwable) {
            this.future.completeExceptionally(throwable);
            this.subscription.cancel();
        }

        @Override
        public void onComplete() {
            try (ByteBuffersInputStream in = new ByteBuffersInputStream(this.buffers);){
                this.future.complete(JsonProcessor.this.unmarshal(in, this.charset, this.type));
            }
            catch (Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }

    private class JsonBody<T>
    extends AbstractBody<T>
    implements Body<T> {
        private JsonBody(T value) {
            this(value, StandardCharsets.UTF_8);
        }

        private JsonBody(T value, Charset charset) {
            super(value, ContentType.of((MimeType)MimeType.JSON, (Charset)Objects.requireNonNull(charset)));
        }

        public HttpRequest.BodyPublisher asBodyPublisher() {
            return this.asPublisher(this.body(), (Charset)this.contentType().charset().orElseThrow());
        }

        HttpRequest.BodyPublisher asPublisher(Object value, Charset charset) {
            HttpRequest.BodyPublisher bodyPublisher;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                JsonProcessor.this.marshal(value, bos, charset);
                bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(bos.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            bos.close();
            return bodyPublisher;
        }
    }
}

