/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.dongliu.commons.concurrent.ThreadFactories;
import net.dongliu.commons.io.Inputs;
import net.dongliu.jlink.util.ProcessResult;

public class ProcessUtils {
    private static final ExecutorService executor = Executors.newCachedThreadPool(ThreadFactories.newBuilder((String)"process-executor").daemon(true).build());

    public static ProcessResult execute(String ... command) {
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            Process process = builder.start();
            Future<String> stdout = executor.submit(() -> {
                try (InputStream in = process.getInputStream();){
                    String string = new String(Inputs.readAll((InputStream)in));
                    return string;
                }
            });
            Future<String> stderr = executor.submit(() -> {
                try (InputStream in = process.getErrorStream();){
                    String string = new String(Inputs.readAll((InputStream)in));
                    return string;
                }
            });
            process.waitFor(10L, TimeUnit.MINUTES);
            return new ProcessResult(process.exitValue(), stdout.get(), stderr.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

