/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.dongliu.commons.Joiner;
import net.dongliu.commons.Strings;
import net.dongliu.commons.collection.Collections2;
import net.dongliu.commons.collection.Maps;
import net.dongliu.commons.collection.Pair;
import net.dongliu.jlink.AddModuleInfo;
import net.dongliu.jlink.DescribeModule;
import net.dongliu.jlink.model.JLinkLauncher;
import net.dongliu.jlink.model.JdkSetting;
import net.dongliu.jlink.util.ModuleInfo;
import net.dongliu.jlink.util.ProcessResult;
import net.dongliu.jlink.util.ProcessUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.Os;

@Mojo(name="link", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JLinkMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}")
    private File projectArtifact;
    @Parameter(property="modulesDirectory", defaultValue="${project.build.directory}/modules")
    private File modulesDirectory;
    @Parameter
    private List<String> options;
    @Parameter
    private List<String> excludeResources;
    @Parameter
    private List<String> excludeFiles;
    @Parameter
    private List<String> excludeJmodSections;
    @Parameter
    private boolean excludeDesktop;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter
    private JdkSetting baseJdk;
    @Parameter
    private List<String> modulePaths;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    private File output;
    @Parameter(defaultValue="${project.build.directory}/jlink_working")
    private File workingDirectory;
    @Parameter
    private List<String> addModules;
    @Parameter
    private boolean bindServices;
    @Parameter
    private List<JLinkLauncher> launchers;
    @Parameter
    private int compress;
    @Parameter
    private boolean stripDebug;
    @Parameter
    private boolean stripJavaDebugAttributes;
    @Parameter
    private boolean stripNativeCommand;
    @Parameter
    private boolean ignoreSigningInformation;
    @Parameter
    private List<String> includeLocales;
    @Parameter
    private String vendorVersion;
    @Parameter
    private String generateJliClasses;
    @Parameter
    private boolean noHeaderFiles;
    @Parameter
    private boolean noManPages;
    @Parameter
    private String packaging;

    public void execute() throws MojoExecutionException {
        String name;
        String packaging = this.project.getModel().getPackaging();
        if (!packaging.equalsIgnoreCase("jar")) {
            this.getLog().error((CharSequence)("require packaging type to be jar or jmod, '" + packaging + " not supported'"));
            return;
        }
        Path jmodsPath = this.getJlinkBaseJdk().resolve("jmods");
        ArrayList<Path> finalModulePaths = new ArrayList<Path>();
        if (this.modulePaths != null) {
            for (String modulePath : this.modulePaths) {
                finalModulePaths.add(Paths.get(modulePath, new String[0]));
            }
        }
        if (!finalModulePaths.contains(jmodsPath)) {
            finalModulePaths.add(jmodsPath);
        }
        if (!finalModulePaths.contains(this.modulesDirectory.toPath())) {
            finalModulePaths.add(this.modulesDirectory.toPath());
        }
        this.copyModules();
        try {
            this.excludeDesktop(jmodsPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        DescribeModule describeModule = new DescribeModule(this.getTools("jar"), this.getTools("jmod"), this.projectArtifact.toPath());
        ModuleInfo projectModuleInfo = describeModule.describe();
        if (this.addModules == null) {
            this.addModules = new ArrayList<String>();
        }
        if (projectModuleInfo != null && !this.addModules.contains(name = projectModuleInfo.name())) {
            this.getLog().info((CharSequence)("add project module: " + name));
            this.addModules.add(name);
        }
        if (this.addModules.isEmpty()) {
            throw new MojoExecutionException("add-modules empty");
        }
        this.runJlink(finalModulePaths);
    }

    private void excludeDesktop(Path jmodsPath) throws MojoExecutionException, IOException {
        if (!this.excludeDesktop) {
            return;
        }
        Path desktopPath = jmodsPath.resolve("java.desktop.jmod");
        String jmodPath = this.getTools("jmod").toString();
        ProcessResult result = ProcessUtils.execute(jmodPath, "list", desktopPath.toString());
        if (result.exitCode() != 0) {
            this.getLog().error((CharSequence)("describe java.desktop module error: " + result.stderr()));
            throw new MojoExecutionException("list desktop jmod failed, exit with: " + result.exitCode());
        }
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> desktopExcludeResources = new ArrayList<String>();
        Path excludeResourcesPath = this.workingDirectory.toPath().resolve("desktop_exclude_resources.list");
        this.getLog().info((CharSequence)("generate desktop excluded resources to " + excludeResourcesPath));
        for (String line : result.stdout().split("\n")) {
            String packageName;
            if ((line = line.trim()).isEmpty() || !line.startsWith("classes/") || line.contains("/beans/") || !(line = line.substring("classes/".length())).contains("/") || set.contains(packageName = Strings.subStringBeforeLast((String)line, (String)"/"))) continue;
            String fileName = Strings.subStringAfterLast((String)line, (String)"/");
            String fileNameEscaped = fileName.replace(".", "\\.").replace("$", "\\$");
            desktopExcludeResources.add("regex:/java.desktop/" + packageName + "/(?!" + fileNameEscaped + ")[^/]+");
            set.add(packageName);
        }
        Files.write(excludeResourcesPath, String.join((CharSequence)"\n", desktopExcludeResources).getBytes(), new OpenOption[0]);
        if (this.excludeResources == null) {
            this.excludeResources = new ArrayList<String>();
        }
        this.excludeResources.add("@" + excludeResourcesPath);
        if (this.excludeFiles == null) {
            this.excludeFiles = new ArrayList<String>();
        }
        this.excludeFiles.add("glob:/java.desktop/lib/*");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Path getTools(String toolName) {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
        if (toolchain != null) {
            String toolPathStr = toolchain.findTool(toolName);
            if (toolPathStr == null) throw new RuntimeException("tools not found in tool chain: " + toolchain);
            return Paths.get(toolPathStr, new String[0]);
        }
        String javaHome = System.getProperty("java.home");
        if (!Os.isFamily((String)"windows")) return Paths.get(javaHome, "bin", toolName);
        toolName = toolName + ".exe";
        return Paths.get(javaHome, "bin", toolName);
    }

    private Path getJlinkBaseJdk() throws MojoExecutionException {
        if (this.baseJdk != null) {
            List toolChains = this.toolchainManager.getToolchains(this.mavenSession, "jdk", this.getToolChainRequirements(this.baseJdk));
            if (toolChains.isEmpty()) {
                throw new MojoExecutionException("Found no tool chain of type 'jdk' and matching requirements '" + this.baseJdk + "'");
            }
            if (toolChains.size() > 1) {
                throw new MojoExecutionException("Found more than one tool chain of type 'jdk' and matching requirements '" + this.baseJdk + "'");
            }
            Toolchain toolchain = (Toolchain)toolChains.get(0);
            String javac = toolchain.findTool("javac");
            if (javac == null) {
                javac = toolchain.findTool("javac.exe");
            }
            if (javac == null) {
                throw new MojoExecutionException("Couldn't locate toolchain directory");
            }
            return new File(javac).toPath().getParent().getParent();
        }
        return Paths.get(System.getProperty("java.home"), new String[0]);
    }

    private Map<String, String> getToolChainRequirements(JdkSetting baseJdk) {
        HashMap<String, String> requirements = new HashMap<String, String>();
        if (baseJdk.getVendor() != null) {
            requirements.put("vendor", baseJdk.getVendor());
        }
        if (baseJdk.getPlatform() != null) {
            requirements.put("platform", baseJdk.getPlatform());
        }
        if (baseJdk.getVersion() != null) {
            requirements.put("version", baseJdk.getVersion());
        }
        return requirements;
    }

    private void copyModules() {
        Path outputPath = this.modulesDirectory.toPath();
        this.createDirectories();
        Set dependencies = this.project.getArtifacts();
        Path modulesBasePath = this.project.getBasedir().toPath().resolve("src/main/modules");
        for (Artifact artifact : dependencies) {
            String moduleInfoSource;
            String scope = artifact.getScope();
            if (!scope.equals("compile") && !scope.equals("runtime")) continue;
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            Path inputFile = artifact.getFile().toPath();
            Path moduleInfoPath = modulesBasePath.resolve(groupId).resolve(artifactId).resolve("module-info.java");
            if (!Files.exists(moduleInfoPath, new LinkOption[0])) {
                this.getLog().debug((CharSequence)("copy module " + artifact.getArtifactId()));
                Path outputJar = this.modulesDirectory.toPath().resolve(inputFile.getFileName());
                try {
                    Files.copy(inputFile, outputJar, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Couldn't copy JAR file", e);
                }
            }
            this.getLog().info((CharSequence)("add module info to artifact: " + artifact.getArtifactId()));
            try {
                moduleInfoSource = new String(Files.readAllBytes(moduleInfoPath), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            AddModuleInfo addModuleInfo = new AddModuleInfo(moduleInfoSource, inputFile, outputPath, true);
            addModuleInfo.run();
        }
        Path projectJarPath = this.projectArtifact.toPath();
        Path outputJar = this.modulesDirectory.toPath().resolve(projectJarPath.getFileName());
        try {
            Files.copy(projectJarPath, outputJar, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Couldn't copy JAR file", e);
        }
    }

    private void runJlink(List<Path> modulePaths) throws AssertionError, MojoExecutionException {
        block55: {
            Path jlinkPath = this.getTools("jlink");
            ArrayList<String> command = new ArrayList<String>();
            command.add(jlinkPath.toString());
            command.add("--add-modules");
            command.add(String.join((CharSequence)",", this.addModules));
            if (this.bindServices) {
                command.add("--bind-services");
            }
            command.add("--module-path");
            command.add(modulePaths.stream().map(Path::toString).collect(Collectors.joining(":")));
            command.add("--output");
            command.add(this.output.toString());
            if (this.launchers != null && !this.launchers.isEmpty()) {
                for (JLinkLauncher launcher : this.launchers) {
                    if (Strings.isNullOrEmpty((String)launcher.getName())) {
                        throw new RuntimeException("launcher name not set");
                    }
                    if (Strings.isNullOrEmpty((String)launcher.getModule())) {
                        throw new RuntimeException("launcher module not set for " + launcher.getName());
                    }
                    command.add("--launcher");
                    command.add(launcher.getName() + "=" + launcher.getModule());
                }
            }
            if (this.options != null && !this.options.isEmpty()) {
                command.add("--add-options");
                command.add(Joiner.of((CharSequence)"\"", (CharSequence)"\"", (CharSequence)" ").join(this.options));
            }
            if (this.compress != 0) {
                command.add("--compress");
                command.add(String.valueOf(this.compress));
            }
            if (this.stripDebug) {
                command.add("--strip-debug");
            }
            if (this.stripJavaDebugAttributes) {
                command.add("--strip-java-debug-attributes");
            }
            if (this.stripNativeCommand) {
                command.add("--strip-native-commands");
            }
            if (this.ignoreSigningInformation) {
                command.add("--ignore-signing-information");
            }
            if (this.excludeResources != null && !this.excludeResources.isEmpty()) {
                command.add("--exclude-resources=" + String.join((CharSequence)",", this.excludeResources));
            }
            if (this.excludeFiles != null && !this.excludeFiles.isEmpty()) {
                command.add("--exclude-files=" + String.join((CharSequence)",", this.excludeFiles));
            }
            if (this.excludeJmodSections != null && !this.excludeJmodSections.isEmpty()) {
                for (String excludeJmodSection : this.excludeJmodSections) {
                    command.add("--exclude-jmod-section=" + excludeJmodSection);
                }
            }
            if (this.includeLocales != null && !this.includeLocales.isEmpty()) {
                command.add("--include-locales=" + String.join((CharSequence)",", this.includeLocales));
            }
            if (this.vendorVersion != null && !this.vendorVersion.isEmpty()) {
                command.add("--vendor-version=" + this.vendorVersion);
            }
            if (this.generateJliClasses != null && !this.generateJliClasses.isEmpty()) {
                command.add("--generate-jli-classes=" + this.generateJliClasses);
            }
            if (this.noHeaderFiles) {
                command.add("--no-header-files");
            }
            if (this.noManPages) {
                command.add("--no-man-pages");
            }
            this.getLog().info((CharSequence)("run jlink: " + Joiner.of((CharSequence)" ").join(command)));
            ProcessResult result = ProcessUtils.execute((String[])Collections2.toArray(command, String[]::new));
            if (result.exitCode() != 0) {
                String message = result.stderr().isEmpty() ? result.stdout() : result.stderr();
                throw new MojoExecutionException("jlink error: " + message);
            }
            Path outPath = this.output.toPath();
            if (Strings.isNotEmpty((String)this.packaging)) {
                if ("zip".equals(this.packaging)) {
                    URI uri = URI.create("jar:file:" + this.output.toString() + ".zip");
                    try (FileSystem zipfs = FileSystems.newFileSystem(uri, Maps.of((Map.Entry)Pair.of((Object)"create", (Object)"true")));){
                        Files.walk(outPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(fp -> {
                            Path pathInZipFile = zipfs.getPath(outPath.relativize((Path)fp).toString(), new String[0]);
                            try {
                                if (pathInZipFile.getParent() != null) {
                                    Files.createDirectories(pathInZipFile.getParent(), new FileAttribute[0]);
                                }
                                Files.copy(fp, pathInZipFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        });
                        break block55;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if ("tgz".equals(this.packaging)) {
                    Path path = Paths.get(outPath + ".tgz", new String[0]);
                    try (OutputStream fos = Files.newOutputStream(path, new OpenOption[0]);
                         BufferedOutputStream bos = new BufferedOutputStream(fos);
                         GzipCompressorOutputStream gos = new GzipCompressorOutputStream((OutputStream)bos);
                         TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)gos);){
                        tos.setBigNumberMode(2);
                        tos.setLongFileMode(2);
                        Files.walk(outPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(fp -> {
                            String pathInTgz = outPath.relativize((Path)fp).toString();
                            File currentFile = fp.toFile();
                            TarArchiveEntry tarEntry = new TarArchiveEntry(currentFile, pathInTgz);
                            tarEntry.setSize(currentFile.length());
                            try {
                                tos.putArchiveEntry((ArchiveEntry)tarEntry);
                                tos.write(IOUtils.toByteArray((InputStream)new FileInputStream(currentFile)));
                                tos.closeArchiveEntry();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        });
                        break block55;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                throw new MojoExecutionException("unsupported compress type:" + this.packaging);
            }
        }
    }

    private void createDirectories() {
        if (!this.workingDirectory.exists()) {
            this.workingDirectory.mkdirs();
        }
        if (!this.modulesDirectory.exists()) {
            this.modulesDirectory.mkdirs();
        }
    }
}

