/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.dongliu.commons.Joiner;
import net.dongliu.commons.collection.Collections2;
import net.dongliu.jlink.DescribeModule;
import net.dongliu.jlink.model.JPackageLauncher;
import net.dongliu.jlink.model.LinuxPackageSetting;
import net.dongliu.jlink.model.MacPackageSetting;
import net.dongliu.jlink.model.WindowsPackageSetting;
import net.dongliu.jlink.util.ModuleInfo;
import net.dongliu.jlink.util.ProcessResult;
import net.dongliu.jlink.util.ProcessUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.Os;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JPackageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}")
    private File projectArtifact;
    @Parameter
    private List<String> jvmOptions;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project.name}")
    private String name;
    @Parameter(required=true)
    private String type;
    @Parameter(defaultValue="${project.version}")
    private String appVersion;
    @Parameter(defaultValue="${project.description}")
    private String description;
    @Parameter
    private String copyright;
    @Parameter
    private String licenseFile;
    @Parameter(defaultValue="${project.build.directory}")
    private String destination;
    @Parameter(defaultValue="${project.groupId}")
    private String vendor;
    @Parameter
    private boolean verbose;
    @Parameter
    private boolean bindServices;
    @Parameter
    private List<String> addModules;
    @Parameter
    private List<String> modulePaths;
    @Parameter
    private String runtimeImage;
    @Parameter
    private String icon;
    @Parameter
    private List<JPackageLauncher> launchers;
    @Parameter
    private List<File> fileAssociations;
    @Parameter
    private List<String> arguments;
    @Parameter
    private List<String> javaOptions;
    @Parameter
    private String module;
    @Parameter(name="mac")
    private MacPackageSetting macPackageSetting;
    @Parameter(name="linux")
    private LinuxPackageSetting linuxPackageSetting;
    @Parameter(name="win")
    private WindowsPackageSetting windowsPackageSetting;

    public void execute() throws MojoExecutionException {
        ModuleInfo projectModuleInfo;
        String packaging = this.project.getModel().getPackaging();
        if (!packaging.equalsIgnoreCase("jar")) {
            this.getLog().error((CharSequence)("require packaging type to be jar or jmod, '" + packaging + " not supported'"));
            return;
        }
        DescribeModule describeModule = new DescribeModule(this.getTools("jar"), this.getTools("jmod"), this.projectArtifact.toPath());
        if (this.module == null && (projectModuleInfo = describeModule.describe()) != null && projectModuleInfo.mainClass() != null) {
            this.module = projectModuleInfo.name() + "/" + projectModuleInfo.mainClass();
            this.getLog().info((CharSequence)("using main module: " + this.module));
        }
        if (this.module == null) {
            throw new RuntimeException("main module required");
        }
        if (this.icon == null) {
            Path fileName;
            Path path = this.project.getBasedir().toPath();
            if (Os.isFamily((String)"windows")) {
                fileName = Paths.get("windows", "icon.ico");
            } else if (Os.isFamily((String)"mac")) {
                fileName = Paths.get("osx", "icon.icns");
            } else if (Os.isFamily((String)"unix")) {
                fileName = Paths.get("linux", "icon.png");
            } else {
                throw new RuntimeException("unsupported os");
            }
            Path iconPath = path.resolve("src").resolve("main").resolve("deploy").resolve(fileName);
            if (Files.exists(iconPath, new LinkOption[0])) {
                this.icon = iconPath.toString();
                this.getLog().info((CharSequence)("using icon: " + this.icon));
            }
        }
        this.getLog().info((CharSequence)("creating jpackage image at " + this.destination + File.separator + this.name));
        this.runJPackage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Path getTools(String toolName) {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
        if (toolchain != null) {
            String toolPathStr = toolchain.findTool(toolName);
            if (toolPathStr == null) throw new RuntimeException("tools not found in tool chain: " + toolchain);
            return Paths.get(toolPathStr, new String[0]);
        }
        String javaHome = System.getProperty("java.home");
        if (!Os.isFamily((String)"windows")) return Paths.get(javaHome, "bin", toolName);
        toolName = toolName + ".exe";
        return Paths.get(javaHome, "bin", toolName);
    }

    private void runJPackage() throws AssertionError {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getTools("jpackage").toString());
        command.add("--name");
        command.add(this.name);
        command.add("--type");
        command.add(this.type);
        command.add("--app-version");
        command.add(this.appVersion);
        command.add("--dest");
        command.add(this.destination);
        command.add("--vendor");
        command.add(this.vendor);
        if (this.description != null) {
            command.add("--description");
            command.add(this.description);
        }
        if (this.copyright != null) {
            command.add("--copyright");
            command.add(this.copyright);
        }
        if (this.licenseFile != null) {
            command.add("-license-file");
            command.add(this.licenseFile);
        }
        if (this.icon != null) {
            command.add("--icon");
            command.add(this.icon);
        }
        if (this.verbose) {
            command.add("--verbose");
        }
        command.add("--module");
        command.add(this.module);
        if (this.bindServices) {
            command.add("--bind-services");
        }
        if (this.addModules != null && !this.addModules.isEmpty()) {
            command.add(" --add-modules");
            command.add(String.join((CharSequence)",", this.addModules));
        }
        if (this.modulePaths != null && !this.modulePaths.isEmpty()) {
            command.add("--module-path");
            command.add(String.join((CharSequence)":", this.modulePaths));
        }
        if (this.runtimeImage != null) {
            command.add("--runtime-image");
            command.add(this.runtimeImage);
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            for (String argument : this.arguments) {
                command.add("--arguments");
                command.add(argument);
            }
        }
        if (this.javaOptions != null && !this.javaOptions.isEmpty()) {
            for (String javaOption : this.javaOptions) {
                command.add("--arguments");
                command.add(javaOption);
            }
        }
        if (this.fileAssociations != null && !this.fileAssociations.isEmpty()) {
            for (File fileAssociation : this.fileAssociations) {
                command.add("--file-associations");
                command.add(fileAssociation.toString());
            }
        }
        if (this.launchers != null && !this.launchers.isEmpty()) {
            for (JPackageLauncher launcher : this.launchers) {
                command.add("--add-launcher");
                command.add(String.format("%s=%s", launcher.getName(), launcher.getFile()));
            }
        }
        if (Os.isFamily((String)"mac") && this.macPackageSetting != null) {
            this.addMacParameters(command);
        }
        if (Os.isFamily((String)"unix") && this.linuxPackageSetting != null) {
            this.addLinuxParameters(command);
        }
        if (Os.isFamily((String)"windows") && this.windowsPackageSetting != null) {
            this.addWindowsParameters(command);
        }
        this.getLog().debug((CharSequence)("run jpackage: " + Joiner.of((CharSequence)" ").join(command)));
        ProcessResult result = ProcessUtils.execute((String[])Collections2.toArray(command, String[]::new));
        if (result.exitCode() != 0) {
            this.getLog().error((CharSequence)("jpackage error: " + result.stderr()));
        }
    }

    private void addWindowsParameters(List<String> command) {
        if (this.windowsPackageSetting.isConsole()) {
            command.add("--win-console");
        }
        if (this.windowsPackageSetting.isDirChooser()) {
            command.add("--win-dir-chooser");
        }
        if (this.windowsPackageSetting.isMenu()) {
            command.add("--win-menu");
        }
        if (this.windowsPackageSetting.getMenuGroup() != null) {
            command.add("--win-menu-group");
            command.add(this.windowsPackageSetting.getMenuGroup());
        }
        if (this.windowsPackageSetting.isPerUserInstall()) {
            command.add("--win-per-user-install");
        }
        if (this.windowsPackageSetting.isShortcut()) {
            command.add("--win-shortcut");
        }
        if (this.windowsPackageSetting.getUpgradeUuid() != null) {
            command.add("--win-upgrade-uuid");
            command.add(this.windowsPackageSetting.getUpgradeUuid());
        }
        if (this.windowsPackageSetting.getInstallDir() != null) {
            command.add("--install-dir");
            command.add(this.windowsPackageSetting.getInstallDir());
        }
    }

    private void addLinuxParameters(List<String> command) {
        if (this.linuxPackageSetting.getPackageName() != null) {
            command.add("--linux-package-name");
            command.add(this.linuxPackageSetting.getPackageName());
        }
        if (this.linuxPackageSetting.getDebMaintainer() != null) {
            command.add("--linux-deb-maintainer");
            command.add(this.linuxPackageSetting.getDebMaintainer());
        }
        if (this.linuxPackageSetting.getMenuGroup() != null) {
            command.add("--linux-menu-group");
            command.add(this.linuxPackageSetting.getMenuGroup());
        }
        if (this.linuxPackageSetting.getPackageDeps() != null) {
            command.add("--linux-package-deps");
            command.add(this.linuxPackageSetting.getPackageDeps());
        }
        if (this.linuxPackageSetting.getRpmLicenseType() != null) {
            command.add("--linux-rpm-license-type");
            command.add(this.linuxPackageSetting.getRpmLicenseType());
        }
        if (this.linuxPackageSetting.getAppRelease() != null) {
            command.add("--linux-app-release");
            command.add(this.linuxPackageSetting.getAppRelease());
        }
        if (this.linuxPackageSetting.getAppCategory() != null) {
            command.add("--linux-app-category");
            command.add(this.linuxPackageSetting.getAppCategory());
        }
        if (this.linuxPackageSetting.isShortcut()) {
            command.add("--linux-shortcut");
        }
        if (this.linuxPackageSetting.getInstallDir() != null) {
            command.add("--install-dir");
            command.add(this.linuxPackageSetting.getInstallDir());
        }
    }

    private void addMacParameters(List<String> command) {
        if (this.macPackageSetting.getPackageIdentifier() != null) {
            command.add("--mac-package-identifier");
            command.add(this.macPackageSetting.getPackageIdentifier());
        }
        if (this.macPackageSetting.getPackageName() != null) {
            command.add("--mac-package-name");
            command.add(this.macPackageSetting.getPackageName());
        }
        if (this.macPackageSetting.getPackageSigningPrefix() != null) {
            command.add("--mac-package-signing-prefix");
            command.add(this.macPackageSetting.getPackageSigningPrefix());
        }
        if (this.macPackageSetting.isSign()) {
            command.add("--mac-sign");
        }
        if (this.macPackageSetting.getSigningKeychain() != null) {
            command.add("--mac-signing-keychain");
            command.add(this.macPackageSetting.getSigningKeychain());
        }
        if (this.macPackageSetting.getSigningKeyUserName() != null) {
            command.add("--mac-signing-key-user-name");
            command.add(this.macPackageSetting.getSigningKeyUserName());
        }
        if (this.macPackageSetting.getInstallDir() != null) {
            command.add("--install-dir");
            command.add(this.macPackageSetting.getInstallDir());
        }
    }
}

