/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.dongliu.commons.Joiner;
import net.dongliu.commons.Strings;
import net.dongliu.commons.collection.Collections2;
import net.dongliu.jlink.AddModuleInfo;
import net.dongliu.jlink.DescribeModule;
import net.dongliu.jlink.model.JLinkLauncher;
import net.dongliu.jlink.model.JdkSetting;
import net.dongliu.jlink.util.ModuleInfo;
import net.dongliu.jlink.util.ProcessResult;
import net.dongliu.jlink.util.ProcessUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.Os;

@Mojo(name="link", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JLinkMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}")
    private File projectArtifact;
    @Parameter(property="modulesDirectory", defaultValue="${project.build.directory}/modules")
    private File modulesDirectory;
    @Parameter
    private List<String> jvmOptions;
    @Parameter
    private List<String> excludeResources;
    @Parameter
    private List<String> excludeFiles;
    @Parameter
    private boolean excludeDesktop;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter
    private JdkSetting baseJdk;
    @Parameter(defaultValue="[]")
    private List<File> modulePaths;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    private File output;
    @Parameter(defaultValue="${project.build.directory}/jlink_working")
    private File workingDirectory;
    @Parameter
    private List<String> addModules;
    @Parameter
    private boolean bindServices;
    @Parameter
    private List<JLinkLauncher> launchers;
    @Parameter
    private int compress;
    @Parameter
    private boolean stripDebug;
    @Parameter
    private boolean ignoreSigningInformation;
    @Parameter
    private boolean noHeaderFiles;
    @Parameter
    private boolean noManPages;

    public void execute() throws MojoExecutionException {
        String name;
        String packaging = this.project.getModel().getPackaging();
        if (!packaging.equalsIgnoreCase("jar")) {
            this.getLog().error((CharSequence)("require packaging type to be jar or jmod, '" + packaging + " not supported'"));
            return;
        }
        Path jmodsPath = this.getJlinkBaseJdk().resolve("jmods");
        List<Path> finalModulePaths = this.modulePaths.stream().map(File::toPath).collect(Collectors.toList());
        if (!finalModulePaths.contains(jmodsPath)) {
            finalModulePaths.add(jmodsPath);
        }
        if (!finalModulePaths.contains(this.modulesDirectory.toPath())) {
            finalModulePaths.add(this.modulesDirectory.toPath());
        }
        this.copyModules();
        try {
            this.excludeDesktop(jmodsPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        DescribeModule describeModule = new DescribeModule(this.getTools("jar"), this.getTools("jmod"), this.projectArtifact.toPath());
        ModuleInfo projectModuleInfo = describeModule.describe();
        if (this.addModules == null) {
            this.addModules = new ArrayList<String>();
        }
        if (projectModuleInfo != null && !this.addModules.contains(name = projectModuleInfo.name())) {
            this.getLog().info((CharSequence)("add project module: " + name));
            this.addModules.add(name);
        }
        if (this.addModules.isEmpty()) {
            throw new MojoExecutionException("add-modules empty");
        }
        this.getLog().info((CharSequence)("creating jlink image at " + this.output.toString()));
        this.runJlink(finalModulePaths);
        try {
            this.tryAddJvmOptions();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void excludeDesktop(Path jmodsPath) throws MojoExecutionException, IOException {
        if (!this.excludeDesktop) {
            return;
        }
        Path desktopPath = jmodsPath.resolve("java.desktop.jmod");
        String jmodPath = this.getTools("jmod").toString();
        ProcessResult result = ProcessUtils.execute(jmodPath, "list", desktopPath.toString());
        if (result.exitCode() != 0) {
            this.getLog().error((CharSequence)("describe java.desktop module error: " + result.stderr()));
            throw new MojoExecutionException("list desktop jmod failed, exit with: " + result.exitCode());
        }
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> desktopExcludeResources = new ArrayList<String>();
        Path excludeResourcesPath = this.workingDirectory.toPath().resolve("desktop_exclude_resources.list");
        this.getLog().info((CharSequence)("generate desktop excluded resources to " + excludeResourcesPath));
        for (String line : result.stdout().split("\n")) {
            String packageName;
            if ((line = line.trim()).isEmpty() || !line.startsWith("classes/") || line.contains("/beans/") || set.contains(packageName = Strings.subStringBeforeLast((String)(line = line.substring("classes/".length())), (String)"/"))) continue;
            String fileName = Strings.subStringAfterLast((String)line, (String)"/");
            String fileNameEscaped = fileName.replace(".", "\\.").replace("$", "\\$");
            desktopExcludeResources.add("regex:/java.desktop/" + packageName + "/(?!" + fileNameEscaped + ")[_a-zA-Z0-9\\.\\$]+");
            set.add(packageName);
        }
        Files.write(excludeResourcesPath, String.join((CharSequence)"\n", desktopExcludeResources).getBytes(), new OpenOption[0]);
        if (this.excludeResources == null) {
            this.excludeResources = new ArrayList<String>();
        }
        this.excludeResources.add("@" + excludeResourcesPath);
        if (this.excludeFiles == null) {
            this.excludeFiles = new ArrayList<String>();
        }
        this.excludeFiles.add("glob:/java.desktop/lib/*");
    }

    private void tryAddJvmOptions() throws IOException {
        if (this.jvmOptions != null && !this.jvmOptions.isEmpty()) {
            String jvmOptionStr = Joiner.of((CharSequence)" ").join(this.jvmOptions);
            List paths = Files.list(this.output.toPath().resolve("bin")).collect(Collectors.toList());
            for (Path path : paths) {
                String content = new String(Files.readAllBytes(path), StandardCharsets.ISO_8859_1);
                if (!content.contains("JLINK_VM_OPTIONS=")) continue;
                this.getLog().info((CharSequence)("add jvm options to launcher: " + path.getFileName()));
                content = content.replace("JLINK_VM_OPTIONS=", "JLINK_VM_OPTIONS=" + jvmOptionStr);
                Files.write(path, content.getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Path getTools(String toolName) {
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
        if (toolchain != null) {
            String toolPathStr = toolchain.findTool(toolName);
            if (toolPathStr == null) throw new RuntimeException("tools not found in tool chain: " + toolchain);
            return Paths.get(toolPathStr, new String[0]);
        }
        String javaHome = System.getProperty("java.home");
        if (!Os.isFamily((String)"windows")) return Paths.get(javaHome, "bin", toolName);
        toolName = toolName + ".exe";
        return Paths.get(javaHome, "bin", toolName);
    }

    private Path getJlinkBaseJdk() throws MojoExecutionException {
        if (this.baseJdk != null) {
            List toolChains = this.toolchainManager.getToolchains(this.mavenSession, "jdk", this.getToolChainRequirements(this.baseJdk));
            if (toolChains.isEmpty()) {
                throw new MojoExecutionException("Found no tool chain of type 'jdk' and matching requirements '" + this.baseJdk + "'");
            }
            if (toolChains.size() > 1) {
                throw new MojoExecutionException("Found more than one tool chain of type 'jdk' and matching requirements '" + this.baseJdk + "'");
            }
            Toolchain toolchain = (Toolchain)toolChains.get(0);
            String javac = toolchain.findTool("javac");
            if (javac == null) {
                javac = toolchain.findTool("javac.exe");
            }
            if (javac == null) {
                throw new MojoExecutionException("Couldn't locate toolchain directory");
            }
            return new File(javac).toPath().getParent().getParent();
        }
        return Paths.get(System.getProperty("java.home"), new String[0]);
    }

    private Map<String, String> getToolChainRequirements(JdkSetting baseJdk) {
        HashMap<String, String> requirements = new HashMap<String, String>();
        if (baseJdk.getVendor() != null) {
            requirements.put("vendor", baseJdk.getVendor());
        }
        if (baseJdk.getPlatform() != null) {
            requirements.put("platform", baseJdk.getPlatform());
        }
        if (baseJdk.getVersion() != null) {
            requirements.put("version", baseJdk.getVersion());
        }
        return requirements;
    }

    private void copyModules() {
        Path outputPath = this.modulesDirectory.toPath();
        this.createDirectories();
        Set dependencies = this.project.getArtifacts();
        Path modulesBasePath = this.project.getBasedir().toPath().resolve("src/main/modules");
        for (Artifact artifact : dependencies) {
            String moduleInfoSource;
            String scope = artifact.getScope();
            if (!scope.equals("compile") && !scope.equals("runtime")) continue;
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            Path inputFile = artifact.getFile().toPath();
            Path moduleInfoPath = modulesBasePath.resolve(groupId).resolve(artifactId).resolve("module-info.java");
            if (!Files.exists(moduleInfoPath, new LinkOption[0])) {
                this.getLog().debug((CharSequence)("copy module " + artifact.getArtifactId()));
                Path outputJar = this.modulesDirectory.toPath().resolve(inputFile.getFileName());
                try {
                    Files.copy(inputFile, outputJar, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Couldn't copy JAR file", e);
                }
            }
            this.getLog().info((CharSequence)("add module info to artifact: " + artifact.getArtifactId()));
            try {
                moduleInfoSource = new String(Files.readAllBytes(moduleInfoPath), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            AddModuleInfo addModuleInfo = new AddModuleInfo(moduleInfoSource, inputFile, outputPath, true);
            addModuleInfo.run();
        }
        Path projectJarPath = this.projectArtifact.toPath();
        Path outputJar = this.modulesDirectory.toPath().resolve(projectJarPath.getFileName());
        try {
            Files.copy(projectJarPath, outputJar, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Couldn't copy JAR file", e);
        }
    }

    private void runJlink(List<Path> modulePaths) throws AssertionError {
        Path jlinkPath = this.getTools("jlink");
        ArrayList<String> command = new ArrayList<String>();
        command.add(jlinkPath.toString());
        command.add("--add-modules");
        command.add(String.join((CharSequence)",", this.addModules));
        if (this.bindServices) {
            command.add("--bind-services");
        }
        command.add("--module-path");
        command.add(modulePaths.stream().map(Path::toString).collect(Collectors.joining(":")));
        command.add("--output");
        command.add(this.output.toString());
        if (this.launchers != null && !this.launchers.isEmpty()) {
            for (JLinkLauncher launcher : this.launchers) {
                command.add("--launcher");
                command.add(launcher.getName() + "=" + launcher.getModule());
            }
        }
        if (this.compress != 0) {
            command.add("--compress");
            command.add(String.valueOf(this.compress));
        }
        if (this.stripDebug) {
            command.add("--strip-debug");
        }
        if (this.ignoreSigningInformation) {
            command.add("--ignore-signing-information");
        }
        if (!this.excludeResources.isEmpty()) {
            command.add("--exclude-resources=" + String.join((CharSequence)",", this.excludeResources));
        }
        if (!this.excludeFiles.isEmpty()) {
            command.add("--exclude-files=" + String.join((CharSequence)",", this.excludeFiles));
        }
        if (this.noHeaderFiles) {
            command.add("--no-header-files");
        }
        if (this.noManPages) {
            command.add("--no-man-pages");
        }
        this.getLog().debug((CharSequence)("run jlink: " + Joiner.of((CharSequence)" ").join(command)));
        ProcessResult result = ProcessUtils.execute((String[])Collections2.toArray(command, String[]::new));
        if (result.exitCode() != 0) {
            this.getLog().error((CharSequence)("jlink error: " + result.stderr()));
        }
    }

    private void createDirectories() {
        if (!this.workingDirectory.exists()) {
            this.workingDirectory.mkdirs();
        }
        if (!this.modulesDirectory.exists()) {
            this.modulesDirectory.mkdirs();
        }
    }
}

