/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink;

import java.nio.file.Path;
import net.dongliu.commons.Strings;
import net.dongliu.jlink.util.ModuleInfo;
import net.dongliu.jlink.util.ProcessResult;
import net.dongliu.jlink.util.ProcessUtils;

public class DescribeModule {
    private final Path jarPath;
    private final Path jmodPath;
    private final Path path;

    public DescribeModule(Path jarPath, Path jmodPath, Path path) {
        this.jarPath = jarPath;
        this.jmodPath = jmodPath;
        this.path = path;
    }

    public ModuleInfo describe() {
        String suffix;
        switch (suffix = Strings.subStringAfterLast((String)this.path.toString(), (String)".").toLowerCase()) {
            case "jar": {
                return this.describeJar();
            }
            case "jmod": {
                return this.describeJmod();
            }
        }
        throw new RuntimeException("unknown module type: " + suffix);
    }

    private ModuleInfo describeJar() {
        ProcessResult result = ProcessUtils.execute(this.jarPath.toString(), "--file", this.path.toString(), "--describe-module");
        if (result.exitCode() != 0) {
            return null;
        }
        String name = Strings.subStringBefore((String)result.stdout(), (String)" ");
        if (name.isEmpty()) {
            return null;
        }
        String mainClass = null;
        for (String line : result.stdout().split("\n")) {
            String[] items = line.trim().split("\\s+");
            if (items.length != 2 || !items[0].trim().equals("main-class")) continue;
            mainClass = items[1].trim();
        }
        return new ModuleInfo(name, mainClass);
    }

    private ModuleInfo describeJmod() {
        ProcessResult result = ProcessUtils.execute(this.jmodPath.toString(), "describe", this.path.toString());
        if (result.exitCode() != 0) {
            return null;
        }
        String name = Strings.subStringBefore((String)result.stdout(), (String)"\n").trim();
        if ((name = Strings.subStringBefore((String)name, (String)"@")).isEmpty()) {
            return null;
        }
        return new ModuleInfo(name, null);
    }
}

