/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import org.moditect.internal.compiler.ModuleInfoCompiler;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleDeclaration;

public class AddModuleInfo {
    private final String moduleInfoSource;
    private final Path inputJar;
    private final Path outputDirectory;
    private final boolean overwriteExistingFiles;

    public AddModuleInfo(String moduleInfoSource, Path inputJar, Path outputDirectory, boolean overwriteExistingFiles) {
        this.moduleInfoSource = moduleInfoSource;
        this.inputJar = inputJar;
        this.outputDirectory = outputDirectory;
        this.overwriteExistingFiles = overwriteExistingFiles;
    }

    public void run() {
        if (Files.isDirectory(this.inputJar, new LinkOption[0])) {
            throw new IllegalArgumentException("Input JAR must not be a directory");
        }
        if (!Files.exists(this.outputDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Output directory doesn't exist: " + this.outputDirectory);
        }
        Path outputJar = this.outputDirectory.resolve(this.inputJar.getFileName());
        if (Files.exists(outputJar, new LinkOption[0]) && !this.overwriteExistingFiles) {
            throw new RuntimeException("File " + outputJar + " already exists");
        }
        try {
            Files.copy(this.inputJar, outputJar, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't copy JAR file", e);
        }
        ModuleDeclaration module = ModuleInfoCompiler.parseModuleInfo((String)this.moduleInfoSource);
        byte[] clazz = ModuleInfoCompiler.compileModuleInfo((ModuleDeclaration)module, null, null);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + outputJar.toUri().toString());
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            Files.write(zipfs.getPath("module-info.class", new String[0]), clazz, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't add module-info.class to JAR", e);
        }
    }
}

