package net.dongliu.jlink;

import net.dongliu.commons.Strings;
import net.dongliu.jlink.util.ModuleInfo;
import net.dongliu.jlink.util.ProcessResult;
import net.dongliu.jlink.util.ProcessUtils;

import java.nio.file.Path;

/**
 * @author dongliu
 */
public class DescribeModule {
    private final Path jarPath;
    private final Path jmodPath;
    private final Path path;

    public DescribeModule(Path jarPath, Path jmodPath, Path path) {
        this.jarPath = jarPath;
        this.jmodPath = jmodPath;
        this.path = path;
    }

    // return mod name
    public ModuleInfo describe() {
        String suffix = Strings.subStringAfterLast(path.toString(), ".").toLowerCase();
        switch (suffix) {
            case "jar":
                return describeJar();
            case "jmod":
                return describeJmod();
            default:
                throw new RuntimeException("unknown module type: " + suffix);
        }
    }

    private ModuleInfo describeJar() {
        ProcessResult result = ProcessUtils.execute(jarPath.toString(), "--file", path.toString(), "--describe-module");
        if (result.exitCode() != 0) {
            return null;
        }
        String name = Strings.subStringBefore(result.stdout(), " ");
        if (name.isEmpty()) {
            return null;
        }
        String mainClass = null;
        for (String line : result.stdout().split("\n")) {
            String[] items = line.trim().split("\\s+");
            if (items.length == 2) {
                if (items[0].trim().equals("main-class")) {
                    mainClass = items[1].trim();
                }
            }
        }
        return new ModuleInfo(name, mainClass);
    }

    private ModuleInfo describeJmod() {
        ProcessResult result = ProcessUtils.execute(jmodPath.toString(), "describe", path.toString());
        if (result.exitCode() != 0) {
            return null;
        }
        String name = Strings.subStringBefore(result.stdout(), "\n").trim();
        name = Strings.subStringBefore(name, "@");
        if (name.isEmpty()) {
            return null;
        }
        return new ModuleInfo(name, null);
    }
}
