package net.dongliu.jlink.model;

/**
 * @author dongliu
 */
public class MacPackageSetting {
    // An identifier that uniquely identifies the application for macOS (defaults to the main class name)
    private String packageIdentifier;
    //  Name of the application as it appears in the menu bar (defaults to the application name)
    private String packageName;
    // When signing the application bundle, the value prepended to all components that need to be signed
    // but don't have an existing bundle identifier
    private String packageSigningPrefix;
    //  Request that the bundle be signed
    private boolean sign;
    // Path of the keychain to search for the signing identity (defaults to the standard keychains)
    private String signingKeychain;
    // Team name portion of the Apple signing identity (for example, "Developer ID Application: ")
    private String signingKeyUserName;
    private String installDir;

    public String getPackageIdentifier() {
        return packageIdentifier;
    }

    public void setPackageIdentifier(String packageIdentifier) {
        this.packageIdentifier = packageIdentifier;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageSigningPrefix() {
        return packageSigningPrefix;
    }

    public void setPackageSigningPrefix(String packageSigningPrefix) {
        this.packageSigningPrefix = packageSigningPrefix;
    }

    public boolean isSign() {
        return sign;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public String getSigningKeychain() {
        return signingKeychain;
    }

    public void setSigningKeychain(String signingKeychain) {
        this.signingKeychain = signingKeychain;
    }

    public String getSigningKeyUserName() {
        return signingKeyUserName;
    }

    public void setSigningKeyUserName(String signingKeyUserName) {
        this.signingKeyUserName = signingKeyUserName;
    }

    public String getInstallDir() {
        return installDir;
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir;
    }
}
