/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import net.dongliu.commons.io.Inputs;
import net.dongliu.jlink.util.ProcessResult;

public class ProcessUtils {
    public static ProcessResult execute(String ... command) {
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            String stderr;
            String stdout;
            Process process = builder.start();
            try (InputStream in = process.getInputStream();){
                stdout = new String(Inputs.readAll((InputStream)in));
            }
            try (InputStream in = process.getErrorStream();){
                stderr = new String(Inputs.readAll((InputStream)in));
            }
            process.waitFor();
            return new ProcessResult(process.exitValue(), stdout, stderr);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

