/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.dongliu.commons.Joiner;
import net.dongliu.commons.Strings;
import net.dongliu.commons.collection.Lists;
import net.dongliu.jlink.AddModuleInfo;
import net.dongliu.jlink.DescribeModule;
import net.dongliu.jlink.JLink;
import net.dongliu.jlink.model.Launcher;
import net.dongliu.jlink.util.ModuleInfo;
import net.dongliu.jlink.util.MojoLog;
import net.dongliu.jlink.util.ProcessResult;
import net.dongliu.jlink.util.ProcessUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

@Mojo(name="link", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class JLinkMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.${project.packaging}")
    private File projectArtifact;
    @Parameter(property="modulesDirectory", defaultValue="${project.build.directory}/modules")
    private File modulesDirectory;
    @Parameter
    private List<String> jvmOptions;
    @Parameter
    private List<String> excludeResources;
    @Parameter
    private List<String> excludeFiles;
    @Parameter
    private boolean excludeDesktop;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter
    private String baseJdk;
    @Parameter(defaultValue="[]")
    private List<File> modulePath;
    @Parameter(defaultValue="${project.build.directory}/jlink")
    private File output;
    @Parameter(defaultValue="${project.build.directory}/jlink_working")
    private File workingDirectory;
    @Parameter
    private List<String> addModules;
    @Parameter
    private List<Launcher> launchers;
    @Parameter
    private int compress;
    @Parameter(defaultValue="false")
    private boolean stripDebug;
    @Parameter(property="ignoreSigningInformation", defaultValue="false")
    private boolean ignoreSigningInformation;
    @Parameter(defaultValue="false")
    private boolean noHeaderFiles;
    @Parameter(defaultValue="false")
    private boolean noManPages;

    public void execute() throws MojoExecutionException {
        String name;
        String packaging = this.project.getModel().getPackaging();
        if (!packaging.equalsIgnoreCase("jar")) {
            this.getLog().error((CharSequence)("require packaging type to be jar or jmod, '" + packaging + " not supported'"));
            return;
        }
        Path javaHome = this.getJavaHome();
        Path jmodsPath = javaHome.resolve("jmods");
        Set<Path> effectiveModulePath = this.modulePath.stream().map(File::toPath).collect(Collectors.toSet());
        effectiveModulePath.add(jmodsPath);
        effectiveModulePath.add(this.modulesDirectory.toPath());
        this.copyModules();
        try {
            this.excludeDesktop(jmodsPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        DescribeModule describeModule = new DescribeModule(this.projectArtifact.toPath());
        ModuleInfo projectModuleInfo = describeModule.describe();
        if (this.addModules == null) {
            this.addModules = new ArrayList<String>();
        }
        if (projectModuleInfo != null && !this.addModules.contains(name = projectModuleInfo.name())) {
            this.getLog().info((CharSequence)("add project module: " + name));
            this.addModules.add(name);
        }
        if (this.addModules.isEmpty()) {
            throw new MojoExecutionException("add-modules empty");
        }
        this.getLog().info((CharSequence)("creating jlink image at " + this.output.toString()));
        new JLink(effectiveModulePath, this.addModules, Lists.nullToEmpty(this.launchers), this.output.toPath(), this.compress, this.stripDebug, this.ignoreSigningInformation, Lists.nullToEmpty(this.excludeResources), Lists.nullToEmpty(this.excludeFiles), new MojoLog(this.getLog()), this.noHeaderFiles, this.noManPages).run();
        try {
            this.tryAddJvmOptions();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void excludeDesktop(Path jmodsPath) throws MojoExecutionException, IOException {
        if (!this.excludeDesktop) {
            return;
        }
        Path desktopPath = jmodsPath.resolve("java.desktop.jmod");
        String jmodPath = Paths.get(System.getProperty("java.home"), "bin", "jmod").toString();
        ProcessResult result = ProcessUtils.execute(jmodPath, "list", desktopPath.toString());
        if (result.exitCode() != 0) {
            throw new MojoExecutionException("list desktop jmod failed, exit with: " + result.exitCode());
        }
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> desktopExcludeResources = new ArrayList<String>();
        Path excludeResourcesPath = this.workingDirectory.toPath().resolve("desktop_exclude_resources.list");
        this.getLog().info((CharSequence)("generate desktop excluded resources to " + excludeResourcesPath));
        for (String line : result.stdout().split("\n")) {
            String packageName;
            if ((line = line.trim()).isEmpty() || !line.startsWith("classes/") || line.contains("/beans/") || set.contains(packageName = Strings.subStringBeforeLast((String)(line = line.substring("classes/".length())), (String)"/"))) continue;
            String fileName = Strings.subStringAfterLast((String)line, (String)"/");
            String fileNameEscaped = fileName.replace(".", "\\.").replace("$", "\\$");
            desktopExcludeResources.add("regex:/java.desktop/" + packageName + "/(?!" + fileNameEscaped + ")[_a-zA-Z0-9\\.\\$]+");
            set.add(packageName);
        }
        Files.write(excludeResourcesPath, String.join((CharSequence)"\n", desktopExcludeResources).getBytes(), new OpenOption[0]);
        if (this.excludeResources == null) {
            this.excludeResources = new ArrayList<String>();
        }
        this.excludeResources.add("@" + excludeResourcesPath);
        if (this.excludeFiles == null) {
            this.excludeFiles = new ArrayList<String>();
        }
        this.excludeFiles.add("glob:/java.desktop/lib/*");
    }

    private void tryAddJvmOptions() throws IOException {
        if (this.jvmOptions != null && !this.jvmOptions.isEmpty()) {
            String jvmOptionStr = Joiner.of((CharSequence)" ").join(this.jvmOptions);
            List paths = Files.list(this.output.toPath().resolve("bin")).collect(Collectors.toList());
            for (Path path : paths) {
                String content = new String(Files.readAllBytes(path), StandardCharsets.ISO_8859_1);
                if (!content.contains("JLINK_VM_OPTIONS=")) continue;
                this.getLog().info((CharSequence)("add jvm options to launcher: " + path.getFileName()));
                content = content.replace("JLINK_VM_OPTIONS=", "JLINK_VM_OPTIONS=" + jvmOptionStr);
                Files.write(path, content.getBytes(StandardCharsets.ISO_8859_1), new OpenOption[0]);
            }
        }
    }

    private Path getJavaHome() throws MojoExecutionException {
        if (this.baseJdk != null) {
            List toolChains = this.toolchainManager.getToolchains(this.mavenSession, "jdk", this.getToolChainRequirements(this.baseJdk));
            if (toolChains.isEmpty()) {
                throw new MojoExecutionException("Found no tool chain of type 'jdk' and matching requirements '" + this.baseJdk + "'");
            }
            if (toolChains.size() > 1) {
                throw new MojoExecutionException("Found more than one tool chain of type 'jdk' and matching requirements '" + this.baseJdk + "'");
            }
            Toolchain toolchain = (Toolchain)toolChains.get(0);
            String javac = toolchain.findTool("javac");
            if (javac == null) {
                javac = toolchain.findTool("javac.exe");
            }
            if (javac == null) {
                throw new MojoExecutionException("Couldn't locate toolchain directory");
            }
            return new File(javac).toPath().getParent().getParent();
        }
        return Paths.get(System.getProperty("java.home"), new String[0]);
    }

    private Map<String, String> getToolChainRequirements(String baseJdk) throws MojoExecutionException {
        String[] requirements;
        HashMap<String, String> toolChainRequirements = new HashMap<String, String>();
        for (String requirement : requirements = baseJdk.split(",")) {
            String[] keyAndValue = requirement.split("=");
            if (keyAndValue.length != 2) {
                throw new MojoExecutionException("Toolchain requirements must be given in the form 'key1=value1,key2=value2,...'.Given value '" + baseJdk + "' doesn't match this pattern.");
            }
            toolChainRequirements.put(keyAndValue[0].trim(), keyAndValue[1].trim());
        }
        return toolChainRequirements;
    }

    public void copyModules() {
        Path outputPath = this.modulesDirectory.toPath();
        this.createDirectories();
        Set dependencies = this.project.getArtifacts();
        Path modulesBasePath = this.project.getBasedir().toPath().resolve("src/main/modules");
        for (Artifact artifact : dependencies) {
            String moduleInfoSource;
            String scope = artifact.getScope();
            if (!scope.equals("compile") && !scope.equals("runtime")) continue;
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            Path inputFile = artifact.getFile().toPath();
            Path moduleInfoPath = modulesBasePath.resolve(groupId).resolve(artifactId).resolve("module-info.java");
            if (!Files.exists(moduleInfoPath, new LinkOption[0])) {
                this.getLog().debug((CharSequence)("copy module " + artifact.getArtifactId()));
                Path outputJar = this.modulesDirectory.toPath().resolve(inputFile.getFileName());
                try {
                    Files.copy(inputFile, outputJar, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Couldn't copy JAR file", e);
                }
            }
            this.getLog().info((CharSequence)("add module info to artifact: " + artifact.getArtifactId()));
            try {
                moduleInfoSource = new String(Files.readAllBytes(moduleInfoPath), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            AddModuleInfo addModuleInfo = new AddModuleInfo(moduleInfoSource, inputFile, outputPath, true);
            addModuleInfo.run();
        }
        Path projectJarPath = this.projectArtifact.toPath();
        Path outputJar = this.modulesDirectory.toPath().resolve(projectJarPath.getFileName());
        try {
            Files.copy(projectJarPath, outputJar, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Couldn't copy JAR file", e);
        }
    }

    private void createDirectories() {
        if (!this.workingDirectory.exists()) {
            this.workingDirectory.mkdirs();
        }
        if (!this.modulesDirectory.exists()) {
            this.modulesDirectory.mkdirs();
        }
    }
}

