/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.dongliu.commons.Joiner;
import net.dongliu.jlink.model.Launcher;
import org.moditect.internal.command.ProcessExecutor;
import org.moditect.spi.log.Log;

public class JLink {
    private final Set<Path> modulePath;
    private final List<String> addModules;
    private final Path output;
    private final List<Launcher> launchers;
    private final Log log;
    private final Integer compression;
    private final boolean stripDebug;
    private final boolean noHeaderFiles;
    private final boolean noManPages;
    private final List<String> excludeResources;
    private final List<String> excludeFiles;
    private boolean ignoreSigningInformation;

    public JLink(Set<Path> modulePath, List<String> addModules, List<Launcher> launchers, Path output, Integer compression, boolean stripDebug, boolean ignoreSigningInformation, List<String> excludeResources, List<String> excludeFiles, Log log, boolean noHeaderFiles, boolean noManPages) {
        this.modulePath = modulePath != null ? modulePath : Collections.emptySet();
        this.addModules = JLink.getModules(addModules);
        this.output = output;
        this.ignoreSigningInformation = ignoreSigningInformation;
        this.launchers = launchers;
        this.compression = compression;
        this.stripDebug = stripDebug;
        this.excludeResources = excludeResources;
        this.excludeFiles = excludeFiles;
        this.log = log;
        this.noHeaderFiles = noHeaderFiles;
        this.noManPages = noManPages;
    }

    private static List<String> getModules(List<String> modules) {
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("At least one module must be added using the <modules> configuration property.");
        }
        return Collections.unmodifiableList(modules);
    }

    public void run() {
        this.runJlink();
    }

    private void runJlink() throws AssertionError {
        String javaHome = System.getProperty("java.home");
        String jlinkBin = javaHome + File.separator + "bin" + File.separator + "jlink";
        ArrayList<String> command = new ArrayList<String>();
        command.add(jlinkBin);
        command.add("--add-modules");
        command.add(String.join((CharSequence)",", this.addModules));
        command.add("--module-path");
        command.add(this.modulePath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
        command.add("--output");
        command.add(this.output.toString());
        if (!this.launchers.isEmpty()) {
            for (Launcher launcher : this.launchers) {
                command.add("--launcher");
                command.add(launcher.getName() + "=" + launcher.getModule());
            }
        }
        if (this.compression != null) {
            command.add("--compress");
            command.add(this.compression.toString());
        }
        if (this.stripDebug) {
            command.add("--strip-debug");
        }
        if (this.ignoreSigningInformation) {
            command.add("--ignore-signing-information");
        }
        if (!this.excludeResources.isEmpty()) {
            command.add("--exclude-resources=" + String.join((CharSequence)",", this.excludeResources));
        }
        if (!this.excludeFiles.isEmpty()) {
            command.add("--exclude-files=" + String.join((CharSequence)",", this.excludeFiles));
        }
        if (this.noHeaderFiles) {
            command.add("--no-header-files");
        }
        if (this.noManPages) {
            command.add("--no-man-pages");
        }
        this.log.info((CharSequence)("run jlink: " + Joiner.of((CharSequence)" ").join(command)));
        ProcessExecutor.run((String)"jlink", command, (Log)this.log);
    }
}

