/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.jlink;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.dongliu.commons.Strings;
import net.dongliu.jlink.util.ModuleInfo;
import net.dongliu.jlink.util.ProcessResult;
import net.dongliu.jlink.util.ProcessUtils;

public class DescribeModule {
    private final Path path;

    public DescribeModule(Path path) {
        this.path = path;
    }

    public ModuleInfo describe() {
        String suffix;
        switch (suffix = Strings.subStringAfterLast((String)this.path.toString(), (String)".").toLowerCase()) {
            case "jar": {
                return this.describeJar();
            }
            case "jmod": {
                return this.describeJmod();
            }
        }
        throw new RuntimeException("unknown module type: " + suffix);
    }

    private ModuleInfo describeJar() {
        String jarPath = Paths.get(System.getProperty("java.home"), "bin", "jar").toString();
        ProcessResult result = ProcessUtils.execute(jarPath, "--file", this.path.toString(), "--describe-module");
        if (result.exitCode() != 0) {
            return null;
        }
        String name = Strings.subStringBefore((String)result.stdout(), (String)" ");
        if (name.isEmpty()) {
            return null;
        }
        return new ModuleInfo(name);
    }

    private ModuleInfo describeJmod() {
        String jmodPath = Paths.get(System.getProperty("java.home"), "bin", "jmod").toString();
        ProcessResult result = ProcessUtils.execute(jmodPath, "describe", "target/decoder-1.0.1.jar");
        if (result.exitCode() != 0) {
            return null;
        }
        String name = Strings.subStringBefore((String)result.stdout(), (String)"\n").trim();
        if (name.isEmpty()) {
            return null;
        }
        return new ModuleInfo(name);
    }
}

