package net.dongliu.jlink.util;

import net.dongliu.commons.io.Inputs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

/**
 * @author dongliu
 */
public class ProcessUtils {

    //TODO: timeout, read stderr in separated thread
    public static ProcessResult execute(String... command) {
        ProcessBuilder builder = new ProcessBuilder(command);

        Process process;
        try {
            process = builder.start();

            String stdout;
            try (InputStream in = process.getInputStream()) {
                stdout = new String(Inputs.readAll(in));
            }
            String stderr;
            try (InputStream in = process.getErrorStream()) {
                stderr = new String(Inputs.readAll(in));
            }
            process.waitFor();
            return new ProcessResult(process.exitValue(), stdout, stderr);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}
