package net.dongliu.jlink;

import net.dongliu.commons.Strings;
import net.dongliu.jlink.util.ModuleInfo;
import net.dongliu.jlink.util.ProcessResult;
import net.dongliu.jlink.util.ProcessUtils;

import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * @author dongliu
 */
public class DescribeModule {
    private final Path path;

    public DescribeModule(Path path) {
        this.path = path;
    }

    // return mod name
    public ModuleInfo describe() {
        String suffix = Strings.subStringAfterLast(path.toString(), ".").toLowerCase();
        switch (suffix) {
            case "jar":
                return describeJar();
            case "jmod":
                return describeJmod();
            default:
                throw new RuntimeException("unknown module type: " + suffix);
        }
    }

    private ModuleInfo describeJar() {
        String jarPath = Paths.get(System.getProperty("java.home"), "bin", "jar").toString();
        ProcessResult result = ProcessUtils.execute(jarPath, "--file", path.toString(), "--describe-module");
        if (result.exitCode() != 0) {
            return null;
        }
        String name = Strings.subStringBefore(result.stdout(), " ");
        if (name.isEmpty()) {
            return null;
        }
        return new ModuleInfo(name);
    }

    private ModuleInfo describeJmod() {
        String jmodPath = Paths.get(System.getProperty("java.home"), "bin", "jmod").toString();
        ProcessResult result = ProcessUtils.execute(jmodPath, "describe", "target/decoder-1.0.1.jar");
        if (result.exitCode() != 0) {
            return null;
        }
        String name = Strings.subStringBefore(result.stdout(), "\n").trim();
        if (name.isEmpty()) {
            return null;
        }
        return new ModuleInfo(name);
    }
}
