/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.internal;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.dongliu.cute.http.NameValue;
import net.dongliu.cute.http.Param;
import net.dongliu.cute.http.exception.RequestsException;

public class UrlUtils {
    public static String encodeQueries(Collection<? extends NameValue> queries, Charset charset) {
        StringBuilder sb = new StringBuilder();
        for (NameValue nameValue : queries) {
            sb.append(URLEncoder.encode(nameValue.name(), charset));
            sb.append('=');
            sb.append(URLEncoder.encode(nameValue.value(), charset));
            sb.append('&');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Param decodeQuery(String s, Charset charset) {
        int idx = s.indexOf("=");
        if (idx < 0) {
            return Param.of("", URLDecoder.decode(s, charset));
        }
        return Param.of(URLDecoder.decode(s.substring(0, idx), charset), URLDecoder.decode(s.substring(idx + 1), charset));
    }

    public static List<Param> decodeQueries(String queryStr, Charset charset) {
        String[] queries = queryStr.split("&");
        ArrayList<Param> list = new ArrayList<Param>(queries.length);
        for (String query : queries) {
            list.add(UrlUtils.decodeQuery(query, charset));
        }
        return list;
    }

    public static String encodeForm(Param query, Charset charset) {
        try {
            return URLEncoder.encode(query.name(), charset.name()) + "=" + URLEncoder.encode(query.value(), charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestsException(e);
        }
    }

    public static String encodeForms(Collection<? extends Param> queries, Charset charset) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Param param : queries) {
                sb.append(URLEncoder.encode(param.name(), charset.name()));
                sb.append('=');
                sb.append(URLEncoder.encode(param.value(), charset.name()));
                sb.append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestsException(e);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Param decodeForm(String s, Charset charset) {
        int idx = s.indexOf("=");
        try {
            if (idx < 0) {
                return Param.of("", URLDecoder.decode(s, charset.name()));
            }
            return Param.of(URLDecoder.decode(s.substring(0, idx), charset.name()), URLDecoder.decode(s.substring(idx + 1), charset.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestsException(e);
        }
    }

    public static List<Param> decodeForms(String queryStr, Charset charset) {
        String[] queries = queryStr.split("&");
        ArrayList<Param> list = new ArrayList<Param>(queries.length);
        for (String query : queries) {
            list.add(UrlUtils.decodeForm(query, charset));
        }
        return list;
    }

    public static URL joinUrl(URL url, Collection<? extends NameValue> params, Charset charset) {
        URL fullURL;
        if (params.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(url.getProtocol()).append(':');
        if (url.getAuthority() != null && !url.getAuthority().isEmpty()) {
            sb.append("//").append(url.getAuthority());
        }
        if (url.getPath() != null) {
            sb.append(url.getPath());
        }
        String query = url.getQuery();
        String newQuery = UrlUtils.encodeQueries(params, charset);
        if (query == null || query.isEmpty()) {
            sb.append('?').append(newQuery);
        } else {
            sb.append('?').append(query).append('&').append(newQuery);
        }
        if (url.getRef() != null) {
            sb.append('#').append(url.getRef());
        }
        try {
            fullURL = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new RequestsException(e);
        }
        return fullURL;
    }
}

