/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;

public class ByteBuffersInputStream
extends InputStream {
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private final ByteBuffer[] buffers;
    private int index;

    public ByteBuffersInputStream(List<ByteBuffer> buffers) {
        this.buffers = (ByteBuffer[])buffers.toArray(ByteBuffer[]::new);
    }

    @Override
    public synchronized int read(byte[] b) {
        Objects.requireNonNull(b);
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        Objects.checkFromIndexSize(off, len, b.length);
        while (this.current().remaining() <= 0) {
            if (this.next()) continue;
            return -1;
        }
        ByteBuffer buffer = this.current();
        int read = Math.min(len, buffer.remaining());
        buffer.get(b, off, read);
        return read;
    }

    @Override
    public synchronized byte[] readAllBytes() {
        int total = 0;
        for (int i = this.index; i < this.buffers.length; ++i) {
            if (total > 0x7FFFFFF7 - this.buffers[i].remaining()) {
                throw new OutOfMemoryError("Required array size too large");
            }
            total += this.buffers[i].remaining();
        }
        byte[] array = new byte[total];
        int offset = 0;
        for (int i = this.index; i < this.buffers.length; ++i) {
            int remaining = this.buffers[i].remaining();
            this.buffers[i].get(array, offset, remaining);
            offset += remaining;
        }
        return array;
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return super.readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) {
        while (this.current().remaining() <= 0) {
            if (this.next()) continue;
            return 0L;
        }
        int remaining = this.current().remaining();
        this.current().position(this.current().limit());
        return remaining;
    }

    @Override
    public synchronized int available() {
        return this.current().remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return super.transferTo(out);
    }

    @Override
    public synchronized int read() {
        while (this.current().remaining() <= 0) {
            if (this.next()) continue;
            return -1;
        }
        return Byte.toUnsignedInt(this.current().get());
    }

    private ByteBuffer current() {
        return this.buffers[this.index];
    }

    private boolean next() {
        if (this.index >= this.buffers.length - 1) {
            return false;
        }
        ++this.index;
        return true;
    }
}

