/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.internal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.dongliu.commons.io.Buffers;

public class AsyncInflater {
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int FRESERVED = 224;
    private Inflater inflater;
    private final CRC32 crc;
    private GzipState gzipState = GzipState.HEADER_START;
    private int flags = -1;
    private int xlen = -1;
    private volatile boolean finished;
    private boolean decideZlibOrNone;
    public static final int GZIP = 1;
    public static final int ZLIB = 2;

    public AsyncInflater(int wrapper) {
        switch (wrapper) {
            case 1: {
                this.inflater = new Inflater(true);
                this.crc = new CRC32();
                break;
            }
            case 2: {
                this.inflater = new Inflater();
                this.crc = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown inflate type:" + wrapper);
            }
        }
    }

    public boolean finished() {
        return this.finished;
    }

    public void decode(ByteBuffer in, Consumer<ByteBuffer> consumer) {
        if (this.finished) {
            in.position(in.limit());
            return;
        }
        if (in.remaining() <= 0) {
            return;
        }
        if (this.decideZlibOrNone) {
            if (in.remaining() < 2) {
                return;
            }
            boolean nowrap = !AsyncInflater.looksLikeZlib(in.getShort(0));
            this.inflater = new Inflater(nowrap);
            this.decideZlibOrNone = false;
        }
        if (this.crc != null) {
            switch (this.gzipState) {
                case FOOTER_START: {
                    if (this.readGZIPFooter(in)) {
                        this.finished = true;
                    }
                    return;
                }
            }
            if (this.gzipState != GzipState.HEADER_END && !this.readGZIPHeader(in)) {
                return;
            }
        }
        int readableBytes = in.remaining();
        if (in.hasArray()) {
            this.inflater.setInput(in.array(), in.arrayOffset() + in.position(), in.remaining());
        } else {
            byte[] array = new byte[in.remaining()];
            in.duplicate().get(array);
            this.inflater.setInput(array);
        }
        int maxOutputLength = this.inflater.getRemaining() << 1;
        ByteBuffer decompressed = ByteBuffer.allocate(maxOutputLength);
        try {
            boolean readFooter = false;
            byte[] outArray = decompressed.array();
            while (!this.inflater.needsInput()) {
                int outIndex = decompressed.arrayOffset() + decompressed.position();
                int length = outArray.length - outIndex;
                if (length == 0) {
                    consumer.accept(decompressed.flip());
                    decompressed = ByteBuffer.allocate(maxOutputLength);
                    outArray = decompressed.array();
                    continue;
                }
                int outputLength = this.inflater.inflate(outArray, outIndex, length);
                if (outputLength > 0) {
                    Buffers.advance((Buffer)decompressed, (int)outputLength);
                    if (this.crc != null) {
                        this.crc.update(outArray, outIndex, outputLength);
                    }
                } else if (this.inflater.needsDictionary()) {
                    throw new RuntimeException("no dictionary was specified");
                }
                if (!this.inflater.finished()) continue;
                if (this.crc == null) {
                    this.finished = true;
                    break;
                }
                readFooter = true;
                break;
            }
            Buffers.advance((Buffer)in, (int)(readableBytes - this.inflater.getRemaining()));
            if (readFooter) {
                this.gzipState = GzipState.FOOTER_START;
                if (this.readGZIPFooter(in)) {
                    this.finished = true;
                }
            }
        }
        catch (DataFormatException e) {
            throw new RuntimeException("decompression failure", e);
        }
        finally {
            decompressed.flip();
            if (decompressed.limit() > 0) {
                consumer.accept(decompressed);
            }
        }
    }

    public void onFinish() {
        if (this.inflater != null) {
            this.inflater.end();
        }
    }

    private boolean readGZIPHeader(ByteBuffer in) {
        switch (this.gzipState) {
            case HEADER_START: {
                if (in.remaining() < 10) {
                    return false;
                }
                byte magic0 = in.get();
                byte magic1 = in.get();
                if (magic0 != 31) {
                    throw new RuntimeException("Input is not in the GZIP format");
                }
                this.crc.update(magic0);
                this.crc.update(magic1);
                int method = Byte.toUnsignedInt(in.get());
                if (method != 8) {
                    throw new RuntimeException("Unsupported compression method " + method + " in the GZIP header");
                }
                this.crc.update(method);
                this.flags = Byte.toUnsignedInt(in.get());
                this.crc.update(this.flags);
                if ((this.flags & 0xE0) != 0) {
                    throw new RuntimeException("Reserved flags are set in the GZIP header");
                }
                this.crc.update(in.get());
                this.crc.update(in.get());
                this.crc.update(in.get());
                this.crc.update(in.get());
                this.crc.update(Byte.toUnsignedInt(in.get()));
                this.crc.update(Byte.toUnsignedInt(in.get()));
                this.gzipState = GzipState.FLG_READ;
            }
            case FLG_READ: {
                if ((this.flags & 4) != 0) {
                    if (in.remaining() < 2) {
                        return false;
                    }
                    int xlen1 = Byte.toUnsignedInt(in.get());
                    int xlen2 = Byte.toUnsignedInt(in.get());
                    this.crc.update(xlen1);
                    this.crc.update(xlen2);
                    this.xlen |= xlen1 << 8 | xlen2;
                }
                this.gzipState = GzipState.XLEN_READ;
            }
            case XLEN_READ: {
                if (this.xlen != -1) {
                    if (in.remaining() < this.xlen) {
                        return false;
                    }
                    byte[] xtra = new byte[this.xlen];
                    in.get(xtra);
                    this.crc.update(xtra);
                }
                this.gzipState = GzipState.SKIP_FNAME;
            }
            case SKIP_FNAME: {
                int b;
                if ((this.flags & 8) != 0) {
                    if (in.remaining() <= 0) {
                        return false;
                    }
                    do {
                        b = Byte.toUnsignedInt(in.get());
                        this.crc.update(b);
                    } while (b != 0 && in.remaining() > 0);
                }
                this.gzipState = GzipState.SKIP_COMMENT;
            }
            case SKIP_COMMENT: {
                int b;
                if ((this.flags & 0x10) != 0) {
                    if (in.remaining() <= 0) {
                        return false;
                    }
                    do {
                        b = Byte.toUnsignedInt(in.get());
                        this.crc.update(b);
                    } while (b != 0 && in.remaining() > 0);
                }
                this.gzipState = GzipState.PROCESS_FHCRC;
            }
            case PROCESS_FHCRC: {
                if ((this.flags & 2) != 0) {
                    if (in.remaining() < 4) {
                        return false;
                    }
                    this.verifyCrc(in);
                }
                this.crc.reset();
                this.gzipState = GzipState.HEADER_END;
            }
            case HEADER_END: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean readGZIPFooter(ByteBuffer buf) {
        if (buf.remaining() < 8) {
            return false;
        }
        this.verifyCrc(buf);
        int dataLength = 0;
        for (int i = 0; i < 4; ++i) {
            dataLength |= Byte.toUnsignedInt(buf.get()) << i * 8;
        }
        int readLength = this.inflater.getTotalOut();
        if (dataLength != readLength) {
            throw new RuntimeException("Number of bytes mismatch. Expected: " + dataLength + ", Got: " + readLength);
        }
        return true;
    }

    private void verifyCrc(ByteBuffer in) {
        long crcValue = 0L;
        for (int i = 0; i < 4; ++i) {
            crcValue |= Byte.toUnsignedLong(in.get()) << i * 8;
        }
        long readCrc = this.crc.getValue();
        if (crcValue != readCrc) {
            throw new RuntimeException("CRC value missmatch. Expected: " + crcValue + ", Got: " + readCrc);
        }
    }

    private static boolean looksLikeZlib(short cmf_flg) {
        return (cmf_flg & 0x7800) == 30720 && cmf_flg % 31 == 0;
    }

    private static enum GzipState {
        HEADER_START,
        HEADER_END,
        FLG_READ,
        XLEN_READ,
        SKIP_FNAME,
        SKIP_COMMENT,
        PROCESS_FHCRC,
        FOOTER_START;

    }
}

