/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.body.AbstractBody;
import net.dongliu.cute.http.body.AggregateBodyPublisher;
import net.dongliu.cute.http.body.Part;

class MultiPartBody
extends AbstractBody<List<Part<?>>> {
    private static final String BOUNDARY = "********************" + System.currentTimeMillis();
    private static final ContentType contentType = ContentType.multiPart(BOUNDARY);
    private static final String LINE_END = "\r\n";

    MultiPartBody(List<Part<?>> body) {
        super(body, contentType);
    }

    @Override
    public HttpRequest.BodyPublisher asBodyPublisher() {
        ArrayList<HttpRequest.BodyPublisher> publishers = new ArrayList<HttpRequest.BodyPublisher>();
        for (Part part : (List)this.body()) {
            publishers.add(HttpRequest.BodyPublishers.ofString("--" + BOUNDARY + LINE_END, StandardCharsets.US_ASCII));
            String header = part.headerData();
            publishers.add(HttpRequest.BodyPublishers.ofString(header, StandardCharsets.US_ASCII));
            publishers.add(part.asPublisher());
            publishers.add(HttpRequest.BodyPublishers.ofByteArray(LINE_END.getBytes()));
        }
        publishers.add(HttpRequest.BodyPublishers.ofString("--" + BOUNDARY + "--\r\n", StandardCharsets.US_ASCII));
        return new AggregateBodyPublisher(publishers);
    }
}

