/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import net.dongliu.cute.http.body.InputSupplier;
import net.dongliu.cute.http.body.ReaderInputStream;

public class InputSuppliers {
    public static InputSupplier of(Path path) {
        return () -> {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static InputSupplier of(byte[] bytes) {
        return () -> new ByteArrayInputStream(bytes);
    }

    static InputSupplier of(String str, Charset charset) {
        Objects.requireNonNull(str);
        Objects.requireNonNull(charset);
        if (str.length() < 262144) {
            return () -> new ByteArrayInputStream(str.getBytes(charset));
        }
        return () -> new ReaderInputStream((Reader)new StringReader(str), charset, 8192);
    }
}

