/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.dongliu.commons.io.Closeables;

class AggregateInputStream
extends InputStream {
    private InputStream[] inputStreams;
    private int index;

    public AggregateInputStream(InputStream ... inputStreams) {
        this.inputStreams = inputStreams;
    }

    public AggregateInputStream(List<InputStream> inputStreams) {
        this.inputStreams = (InputStream[])inputStreams.toArray(InputStream[]::new);
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        if (this.EOF()) {
            return -1;
        }
        do {
            int count;
            if ((count = this.current().read(b)) < 0) continue;
            return count;
        } while (this.next());
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.EOF()) {
            return -1;
        }
        do {
            int count;
            if ((count = this.current().read(b, off, len)) < 0) continue;
            return count;
        } while (this.next());
        return -1;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (this.EOF()) {
            return 0L;
        }
        return this.current().skip(n);
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.EOF()) {
            return 0;
        }
        return this.current().available();
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.EOF()) {
            return -1;
        }
        do {
            int value;
            if ((value = this.current().read()) < 0) continue;
            return value;
        } while (this.next());
        return -1;
    }

    @Override
    public synchronized void close() throws IOException {
        for (InputStream in : this.inputStreams) {
            Closeables.closeQuietly((AutoCloseable)in);
        }
    }

    private boolean next() {
        if (this.index >= this.inputStreams.length - 1) {
            return false;
        }
        Closeables.closeQuietly((AutoCloseable)this.inputStreams[this.index]);
        ++this.index;
        return true;
    }

    private InputStream current() {
        return this.inputStreams[this.index];
    }

    private boolean EOF() {
        return this.index >= this.inputStreams.length;
    }
}

