/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.dongliu.commons.io.InputStreams;
import net.dongliu.commons.io.Readers;
import net.dongliu.commons.reflect.TypeInfer;
import net.dongliu.cute.http.Headers;
import net.dongliu.cute.http.Method;
import net.dongliu.cute.http.RawResponse;
import net.dongliu.cute.http.Response;
import net.dongliu.cute.http.ResponseHandler;
import net.dongliu.cute.http.ResponseInfo;
import net.dongliu.cute.http.exception.IllegalStatusCodeException;
import net.dongliu.cute.http.exception.JsonMarshallerNotFoundException;
import net.dongliu.cute.http.json.JsonMarshaller;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResponseContext
implements AutoCloseable {
    private final RawResponse<InputStream> resp;
    private boolean decompressBody = true;
    private final @Nullable JsonMarshaller jsonMarshaller;

    ResponseContext(RawResponse<InputStream> resp, @Nullable JsonMarshaller jsonMarshaller) {
        this.resp = Objects.requireNonNull(resp);
        this.jsonMarshaller = jsonMarshaller;
    }

    public ResponseContext decompressBody(boolean decompressBody) {
        this.decompressBody = decompressBody;
        return this;
    }

    public ResponseContext checkStatusCode(IntPredicate predicate) throws IllegalStatusCodeException {
        ResponseInfo info = this.resp.info();
        if (!predicate.test(info.statusCode())) {
            throw new IllegalStatusCodeException(info.statusCode());
        }
        return this;
    }

    public <T> Response<T> handle(ResponseHandler<InputStream, T> responseHandler) {
        Response<T> response;
        block8: {
            ResponseInfo info = this.resp.info();
            InputStream body = this.decompressBody ? this.wrapCompressedInput(this.resp.method(), info.statusCode(), info.headers(), this.resp.body()) : this.resp.body();
            ResponseInfo respInfo = new ResponseInfo(info.statusCode(), info.headers());
            InputStream inputStream = body;
            try {
                T result = responseHandler.handle(respInfo, body);
                response = new Response<T>(this.resp.url(), info.statusCode(), info.headers(), result);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return response;
    }

    public <T> Response<T> handleAsReader(ResponseHandler<Reader, T> handler, Charset charset) {
        return this.handle((info, body) -> {
            try (InputStreamReader reader = new InputStreamReader((InputStream)body, charset);){
                Object t = handler.handle(info, reader);
                return t;
            }
        });
    }

    public <T> Response<T> handleAsReader(ResponseHandler<Reader, T> handler) {
        ResponseInfo info = this.resp.info();
        return this.handleAsReader(handler, info.getCharset().orElse(StandardCharsets.UTF_8));
    }

    private InputStream wrapCompressedInput(Method method, int status, Headers headers, InputStream input) {
        String contentEncoding;
        if (this.noBody(method, status)) {
            return input;
        }
        switch (contentEncoding = headers.getHeader("Content-Encoding").orElse("")) {
            case "gzip": {
                try {
                    return new GZIPInputStream(input);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            case "deflate": {
                return new InflaterInputStream(input, new Inflater(true));
            }
        }
        return input;
    }

    private boolean noBody(Method method, int status) {
        return method.equals((Object)Method.HEAD) || status >= 100 && status < 200 || status == 304 || status == 204;
    }

    public Response<String> readToString() {
        return this.handleAsReader((info, body) -> Readers.readAll((Reader)body));
    }

    public Response<String> readToString(Charset charset) {
        return this.handleAsReader((info, body) -> Readers.readAll((Reader)body), charset);
    }

    public Response<byte[]> readToBytes() {
        return this.handle((info, body) -> body.readAllBytes());
    }

    public <T> Response<T> decodeJson(Class<T> type) {
        Objects.requireNonNull(type);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        return this.handleAsReader((info, body) -> this.jsonMarshaller.unmarshal((Reader)body, type));
    }

    public <T> Response<T> decodeJson(TypeInfer<T> typeInfer) {
        Objects.requireNonNull(typeInfer);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        return this.handleAsReader((info, body) -> this.jsonMarshaller.unmarshal((Reader)body, typeInfer.getType()));
    }

    public <T> Response<T> decodeJson(Class<T> type, Charset charset) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(charset);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        return this.handleAsReader((info, body) -> this.jsonMarshaller.unmarshal((Reader)body, type), charset);
    }

    public <T> Response<T> decodeJson(TypeInfer<T> typeInfer, Charset charset) {
        Objects.requireNonNull(typeInfer);
        Objects.requireNonNull(charset);
        if (this.jsonMarshaller == null) {
            throw new JsonMarshallerNotFoundException();
        }
        return this.handleAsReader((info, body) -> this.jsonMarshaller.unmarshal((Reader)body, typeInfer.getType()), charset);
    }

    public Response<Path> writeTo(Path path) {
        return this.handle((info, body) -> {
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                body.transferTo(out);
            }
            return null;
        });
    }

    public Response<Void> writeTo(OutputStream out) {
        return this.handle((info, body) -> {
            body.transferTo(out);
            return null;
        });
    }

    public Response<Void> writeTo(Writer writer) {
        Objects.requireNonNull(writer);
        return this.handleAsReader((info, body) -> {
            Readers.transferTo((Reader)body, (Writer)writer);
            return null;
        });
    }

    public Response<Void> writeTo(Writer writer, Charset charset) {
        Objects.requireNonNull(writer);
        Objects.requireNonNull(charset);
        return this.handleAsReader((info, body) -> {
            Readers.transferTo((Reader)body, (Writer)writer);
            return null;
        });
    }

    public Response<Void> discard() {
        return this.handle((info, body) -> {
            InputStreams.discardAll((InputStream)body);
            return null;
        });
    }

    @Override
    public void close() {
        this.discard();
    }
}

