/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import net.dongliu.cute.http.AbstractRequestBuilder;
import net.dongliu.cute.http.AsyncResponseContext;
import net.dongliu.cute.http.Client;
import net.dongliu.cute.http.Headers;
import net.dongliu.cute.http.Method;
import net.dongliu.cute.http.RawResponse;
import net.dongliu.cute.http.Request;
import net.dongliu.cute.http.ResponseContext;
import net.dongliu.cute.http.ResponseInfo;
import net.dongliu.cute.http.exception.RequestInterruptedException;
import net.dongliu.cute.http.exception.RequestsException;
import net.dongliu.cute.http.internal.RequestUtils;

public class RequestContext
extends AbstractRequestBuilder<RequestContext> {
    private final Client client;

    RequestContext(Client client, Method method, URL url) {
        super(method, url, client.jsonMarshaller().orElse(null));
        this.client = client;
    }

    public ResponseContext send() {
        URL url;
        HttpResponse<InputStream> response;
        Request request = this.build();
        HttpRequest httpRequest = RequestUtils.toHttpRequest(request);
        try {
            response = this.client.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RequestInterruptedException(e);
        }
        int status = response.statusCode();
        HttpHeaders httpHeaders = response.headers();
        Headers headers = Headers.ofHttpHeaders(httpHeaders);
        try {
            url = response.uri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RequestsException(e);
        }
        ResponseInfo responseInfo = new ResponseInfo(status, headers);
        RawResponse<InputStream> resp = new RawResponse<InputStream>(this.method, url, responseInfo, response.body());
        return new ResponseContext(resp, this.client.jsonMarshaller().orElse(null));
    }

    public AsyncResponseContext sendAsync() {
        Request request = this.build();
        HttpRequest httpRequest = RequestUtils.toHttpRequest(request);
        CompletionStage responseFuture = this.client.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofPublisher()).thenApply(r -> {
            URL url;
            Headers headers = Headers.ofHttpHeaders(r.headers());
            try {
                url = r.uri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RequestsException(e);
            }
            ResponseInfo responseInfo = new ResponseInfo(r.statusCode(), headers);
            return new RawResponse<Flow.Publisher>(this.method, url, responseInfo, (Flow.Publisher)r.body());
        });
        return new AsyncResponseContext((CompletableFuture<RawResponse<Flow.Publisher<List<ByteBuffer>>>>)responseFuture, this.client.jsonMarshaller().orElse(null));
    }

    @Override
    protected RequestContext self() {
        return this;
    }
}

