/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import net.dongliu.cute.http.AbstractRequestBuilder;
import net.dongliu.cute.http.Cookie;
import net.dongliu.cute.http.Header;
import net.dongliu.cute.http.Method;
import net.dongliu.cute.http.Param;
import net.dongliu.cute.http.body.Body;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Request {
    private final Method method;
    private final List<Header> headers;
    private final List<Cookie> cookies;
    private final List<Param> params;
    private final Charset paramCharset;
    private final @Nullable Body<?> body;
    private final boolean acceptCompressed;
    private final @Nullable PasswordAuthentication basicAuth;
    private final URL url;
    private final @Nullable String userAgent;
    private final @Nullable String referer;
    private final Duration timeout;

    Request(AbstractRequestBuilder<?> builder) {
        this.method = builder.method;
        this.url = builder.url;
        this.headers = builder.headers;
        this.cookies = builder.cookies;
        this.userAgent = builder.userAgent;
        this.referer = builder.referer;
        this.paramCharset = builder.paramCharset;
        this.body = builder.body;
        this.acceptCompressed = builder.acceptCompressed;
        this.basicAuth = builder.basicAuth;
        this.params = builder.params;
        this.timeout = builder.timeout;
    }

    public Method method() {
        return this.method;
    }

    public List<Header> headers() {
        return this.headers;
    }

    public List<Cookie> cookies() {
        return this.cookies;
    }

    public Optional<String> userAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    public Optional<String> referer() {
        return Optional.ofNullable(this.referer);
    }

    public Charset paramCharset() {
        return this.paramCharset;
    }

    public Optional<Body<?>> body() {
        return Optional.ofNullable(this.body);
    }

    public boolean acceptCompressed() {
        return this.acceptCompressed;
    }

    public Optional<PasswordAuthentication> basicAuth() {
        return Optional.ofNullable(this.basicAuth);
    }

    public URL url() {
        return this.url;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public List<Param> params() {
        return this.params;
    }
}

