/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import net.dongliu.cute.http.NameValue;

public class Header
implements NameValue {
    private final String name;
    private final String value;

    private Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static Header of(String name, Date date) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(date);
        return Header.of(name, date.toInstant());
    }

    public static Header of(String name, ZonedDateTime dateTime) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(dateTime);
        return new Header(name, DateTimeFormatter.RFC_1123_DATE_TIME.format(dateTime.withZoneSameInstant(ZoneOffset.UTC)));
    }

    public static Header of(String name, OffsetDateTime dateTime) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(dateTime);
        return new Header(name, DateTimeFormatter.RFC_1123_DATE_TIME.format(dateTime.withOffsetSameInstant(ZoneOffset.UTC)));
    }

    public static Header of(String name, Instant instant) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(instant);
        return new Header(name, DateTimeFormatter.RFC_1123_DATE_TIME.format(instant.atOffset(ZoneOffset.UTC)));
    }

    public static Header of(String name, long value) {
        return new Header(name, String.valueOf(value));
    }

    public static Header of(String name, boolean value) {
        return new Header(name, String.valueOf(value));
    }

    public static Header of(String name, String value) {
        return new Header(Objects.requireNonNull(name), Objects.requireNonNull(value));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header that = (Header)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return this.name + ": " + this.value;
    }
}

