package net.dongliu.cute.http;


import java.net.URL;

import static java.util.Objects.requireNonNull;

/**
 * Http Response with body be transformed
 *
 * @author Liu Dong
 */
public class Response<T> {
    private final URL url;
    private final int statusCode;
    private final Headers headers;
    private final T body;

    Response(URL url, int statusCode, Headers headers, T body) {
        this.url = requireNonNull(url);
        this.statusCode = statusCode;
        this.headers = requireNonNull(headers);
        // we do not check null here, cause for type Void we use null.
        this.body = body;
    }

    /**
     * Get actual url (redirected)
     */
    public URL url() {
        return url;
    }

    /**
     * Return http response status code.
     *
     * @return the status code
     */
    public int statusCode() {
        return statusCode;
    }

    /**
     * Get all cookies returned by this response.
     *
     * @return a immutable list of cookies
     */
    public Cookies cookies() {
        return headers.cookies();
    }

    /**
     * Get all response headers
     */
    public Headers headers() {
        return headers;
    }

    /**
     * Return the response body.
     *
     * @return The response body
     */
    public T body() {
        return body;
    }

}
