package net.dongliu.cute.http;

import net.dongliu.commons.Lazy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * Collection of Cookie
 */
public class Cookies {
    private final List<Cookie> cookies;
    private final Lazy<Map<String, Cookie>> map;

    /**
     * only for internal use
     */
    Cookies(List<Cookie> cookies) {
        this.cookies = List.copyOf(cookies);
        this.map = Lazy.of(() -> toMap(cookies));
    }

    private static Map<String, Cookie> toMap(List<Cookie> cookies) {
        var map = new HashMap<String, Cookie>();
        for (Cookie cookie : cookies) {
            map.put(cookie.name(), cookie);
        }
        return map;
    }

    /**
     * Get cookie with name, if not exists, return empty Optional
     */
    public Optional<Cookie> getCookie(String name) {
        var c = map.get().get(name);
        return Optional.ofNullable(c);
    }

    /**
     * Return all cookies
     */
    public List<Cookie> allCookies() {
        return cookies;
    }
}
