/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.json;

import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import net.dongliu.commons.Lazy;
import net.dongliu.cute.http.json.JsonMarshaller;

public class JsonMarshallers {
    private static final Lazy<Optional<JsonMarshaller>> jsonMarshaller = Lazy.of(JsonMarshallers::loadJsonMarshaller);

    public static Optional<JsonMarshaller> getJsonMarshaller() {
        return (Optional)jsonMarshaller.get();
    }

    private static Optional<JsonMarshaller> loadJsonMarshaller() {
        Iterator<JsonMarshaller> iterator = ServiceLoader.load(JsonMarshaller.class).iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        JsonMarshaller marshaller = iterator.next();
        if (iterator.hasNext()) {
            System.err.println("CuteHttp: multi json marshaller implementation found, ignore others. ");
        }
        return Optional.of(marshaller);
    }
}

