/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.body;

import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import net.dongliu.cute.http.ContentType;
import net.dongliu.cute.http.body.InputSupplier;
import net.dongliu.cute.http.body.InputSuppliers;

public abstract class Part<T> {
    private final String name;
    private final T content;
    private static final String LINE_END = "\r\n";

    protected Part(String name, T content) {
        this.name = Objects.requireNonNull(name);
        this.content = Objects.requireNonNull(content);
    }

    public String name() {
        return this.name;
    }

    public T content() {
        return this.content;
    }

    protected abstract HttpRequest.BodyPublisher asPublisher();

    protected abstract String headerData();

    static class TextPart
    extends Part<String> {
        TextPart(String name, String text) {
            super(name, text);
        }

        @Override
        protected HttpRequest.BodyPublisher asPublisher() {
            return HttpRequest.BodyPublishers.ofInputStream(InputSuppliers.of((String)this.content(), StandardCharsets.UTF_8));
        }

        @Override
        protected String headerData() {
            StringBuilder sb = new StringBuilder("Content-Disposition: form-data; name=\"").append(this.name()).append("\"");
            sb.append(Part.LINE_END);
            sb.append(Part.LINE_END);
            return sb.toString();
        }
    }

    static class FilePart
    extends Part<InputSupplier> {
        private final String filename;
        private ContentType contentType;

        FilePart(String name, String filename, InputSupplier supplier, ContentType contentType) {
            super(name, supplier);
            this.filename = Objects.requireNonNull(filename);
            this.contentType = Objects.requireNonNull(contentType);
        }

        @Override
        protected String headerData() {
            StringBuilder sb = new StringBuilder("Content-Disposition: form-data; name=\"").append(this.name()).append("\"");
            sb.append("; filename=\"").append(this.filename).append('\"');
            sb.append(Part.LINE_END);
            sb.append("Content-Type").append(": ").append(this.contentType.toString()).append(Part.LINE_END);
            sb.append(Part.LINE_END);
            return sb.toString();
        }

        @Override
        protected HttpRequest.BodyPublisher asPublisher() {
            return HttpRequest.BodyPublishers.ofInputStream((Supplier)this.content());
        }

        public ContentType contentType() {
            return this.contentType;
        }
    }
}

